<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Swipe to Delete</title>
<link rel="stylesheet" href="styles.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<style>
body, html {
  margin: 0;
  padding: 0;
  height: 100%;
}

.container {
  width: 100%;
  height: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
}

.item {
  position: relative;
  width: 200px;
  height: 50px;
  background-color: #ccc;
  display: flex;
  align-items: center;
  justify-content: center;
  overflow: hidden;
  cursor: grab;
}

.delete-btn {
  width: 0;
  height: 100%;
  background-color: #f00;
  color: #fff;
  display: flex;
  align-items: center;
  justify-content: center;
  position: absolute;
  top: 0;
  right: 0;
  transition: width 0.3s ease;
  overflow: hidden; /* Adicionado */
  white-space: nowrap; /* Adicionado */
}

.delete-btn span {
  display: inline-block; /* Adicionado */
  transition: opacity 0.3s ease; /* Adicionado */
  opacity: 0; /* Adicionado */
}

.delete-btn.active span {
  opacity: 1; /* Adicionado */
}

</style>
<body>

<div class="container">
  <div class="item">Swipe left to delete</div>
</div>

<script>
$(document).ready(function() {
  const item = $('.item');
  const deleteBtn = $('<div class="delete-btn"><span>Delete</span></div>');
  item.append(deleteBtn);

  let isDeleting = false;
  let startTouchX = 0;
  let startMouseX = 0;
  let isGrabbing = false;

  item.on('touchstart', handleTouchStart);
  item.on('touchmove', handleTouchMove);
  item.on('touchend', handleTouchEnd);

  item.on('mousedown', handleMouseDown);
  item.on('mousemove', handleMouseMove);
  item.on('mouseup', handleMouseUp);

  deleteBtn.on('click', handleDeleteButtonClick);

  function handleTouchStart(event) {
    if (!isDeleting) {
      startTouchX = event.originalEvent.touches[0].clientX;
    }
  }

  function handleTouchMove(event) {
    if (!isDeleting) {
      const touchX = event.originalEvent.touches[0].clientX;
      const deltaX = startTouchX - touchX;

      if (deltaX > 50) {
        isDeleting = true;
        deleteBtn.addClass('active');
        deleteBtn.css('width', '100%');
      }
    }
  }

  function handleTouchEnd(event) {
    if (isDeleting && startTouchX - event.originalEvent.changedTouches[0].clientX > 150) {
      item.css('transition', 'transform 0.3s ease');
      item.css('transform', 'translateX(-100%)');
      setTimeout(() => {
        item.css('transform', 'translateX(-100%) translateY(-100%)');
        setTimeout(() => {
          item.remove();
        }, 300);
      }, 300);
    } else {
      deleteBtn.removeClass('active');
      deleteBtn.css('width', '0');
    }
    isDeleting = false;
  }

  function handleMouseDown(event) {
    if (!isDeleting) {
      startMouseX = event.clientX;
      isGrabbing = true;
    }
  }

  function handleMouseMove(event) {
    if (isGrabbing && !isDeleting && !isMouseOverDeleteButton(event)) {
      const mouseX = event.clientX;
      const deltaX = startMouseX - mouseX;

      if (deltaX > 50) {
        isDeleting = true;
        deleteBtn.addClass('active');
        deleteBtn.css('width', '100%');
      }
    }
  }

  function handleMouseUp(event) {
    if (isDeleting && startMouseX - event.clientX > 150) {
      item.css('transition', 'transform 0.3s ease');
      item.css('transform', 'translateX(-100%)');
      setTimeout(() => {
        item.css('transform', 'translateX(-100%) translateY(-100%)');
        setTimeout(() => {
          item.remove();
        }, 300);
      }, 300);
    } else {
      deleteBtn.removeClass('active');
      deleteBtn.css('width', '0');
    }
    isDeleting = false;
    isGrabbing = false;
  }

  function handleDeleteButtonClick() {
    item.css('transition', 'transform 0.3s ease');
    item.css('transform', 'translateX(-100%)');
    setTimeout(() => {
      item.css('transform', 'translateX(-100%) translateY(-100%)');
      setTimeout(() => {
        item.remove();
      }, 300);
    }, 300);
  }

  function isMouseOverDeleteButton(event) {
    const deleteBtnRect = deleteBtn[0].getBoundingClientRect();
    const mouseX = event.clientX;
    const mouseY = event.clientY;

    return (
      mouseX >= deleteBtnRect.left &&
      mouseX <= deleteBtnRect.right &&
      mouseY >= deleteBtnRect.top &&
      mouseY <= deleteBtnRect.bottom
    );
  }
});
</script>

</body>
</html>
