<!DOCTYPE html>
<html lang="pt">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <style>
        :root {
            --body-bg: rgb(204, 204, 204);
            --white: #ffffff;
            --darkWhite: #ccc;
            --black: #000000;
            --dark: #615c60;
            --themeColor: #560085;
            --pageShadow: 0 0 0.5cm rgba(0, 0, 0, 0.5);
        }

        @import url('https://fonts.googleapis.com/css2?family=Arimo:wght@400;500&family=Noto+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;1,100&display=swap');

        body {
            background-color: var(--body-bg);
            -webkit-print-color-adjust: exact !important;
        }


        .page {
            background: var(--white);
            display: block;
            margin: 0 auto;
            position: relative;
            box-shadow: var(--pageShadow);
        }

        .page[size="Ticket"] {
            width: 8cm;
            overflow: unset;
        }

        .bb {
            border-bottom: 3px solid var(--darkWhite);
        }

        .top-content {
            padding-bottom: 15px;
        }

        .logo img {
            height: 20px;
        }

        .top-left p {
            margin: 0;
        }

        .top-left .graphic-path {
            height: 40px;
            position: relative;
        }

        .top-left .graphic-path::before {
            content: "";
            height: 20px;
            background-color: var(--dark);
            position: absolute;
            left: 15px;
            right: 0;
            top: -15px;
            z-index: 2;
        }

        .top-left .graphic-path::after {
            content: "";
            height: 22px;
            width: 17px;
            background: var(--black);
            position: absolute;
            top: -13px;
            left: 6px;
            transform: rotate(45deg);
        }

        .top-left .graphic-path p {
            color: var(--white);
            height: 40px;
            left: 0;
            right: -100px;
            text-transform: uppercase;
            background-color: var(--themeColor);
            font: 26px;
            z-index: 3;
            position: absolute;
            padding-left: 10px;
        }

        .store-user {
            padding-bottom: 25px;
        }

        .store-user p {
            margin: 0;
            font-weight: 600;
        }

        .store-user .address {
            font-weight: 400;
        }

        .store-user h2 {
            color: var(--themeColor);
            font-family: 'Rajdhani', sans-serif;
        }

        .extra-info p span {
            font-weight: 400;
        }

        .table td,
        .table th {
            text-align: center;
            vertical-align: middle;
        }

        tr th:first-child,
        tr td:first-child {
            text-align: left;
        }

        .media img {
            height: 60px;
            width: 60px;
        }

        .media p {
            font-weight: 400;
            margin: 0;
        }

        .media p.title {
            font-weight: 600;
        }

        .media-body>p {
            font-weight: 600;
        }

        .balance-info .table td,
        .balance-info .table th {
            padding: 0;
            border: 0;
        }

        .balance-info tr td:first-child {
            font-weight: 600;
        }

        tfoot {
            border-top: 2px solid var(--darkWhite);
        }

        tfoot td {
            font-weight: 600;
        }

        footer {
            text-align: center;
            position: absolute;
            bottom: 30px;
            left: 0;
            right: 0;
            background: var(--white);
            padding: 3rem;
        }

        footer hr {
            margin-bottom: -22px;
            border-top: 3px solid var(--darkWhite);
        }

        footer a {
            color: var(--themeColor);
        }

        @media print {
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
            }

            body {
                margin: 0;
                padding: 0;
                background: white;
            }

            .page,
            .page * {
                visibility: visible;
            }

            .page {
                position: absolute;
                left: 0;
                top: 0;
                box-shadow: none;
                margin: 0;
                width: 8cm;
            }

            .my-5 {
                margin: 0 !important;
            }

            @page {
                size: 80mm auto;
                margin: 0;
            }
        }

        .tabela thead td {
            background-color: #0000000d;
        }

        .tabela td {
            text-align: left;
        }

        .tabela-principal thead {
            font-weight: 600;
        }

        .tabela-principal thead td {
            background: none;
        }

        .tabela-principal td {
            border: none;
        }

        .ttb tbody tr:nth-child(even) {
            background-color: red !important;
        }
    </style>
</head>

<body>
    <div class="my-5 page" size="Ticket">
        <div class="p-3">
            <section class="top-content d-flex justify-content-between" style="padding-bottom: 0; padding-top: 1.5rem;">
                <div class="col-12" style="display: flex; justify-content: center;">
                    <div class="logo">
                        <img src="logo.png" alt="" style="width: 100px; height: 100px;" class="img-fluid" id="logotipoDocumento" style="margin-bottom: .5rem;">
                    </div>
                </div>
            </section>
            <section class="store-user" style="padding-bottom: 0; border-bottom: 1px solid #000;">
                <div class="col-12">
                    <div class="row pb-1">
                        <div class="col-12" style="display: flex; justify-content: center; flex-direction: column;">

                            <p style="font-size: 12pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: bold;" id="nomeEmpresaDocumento"></p>
                            <p style="font-size: 8pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: bold;" id="nifempre"></p>
                            <p style="font-size: 8pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: bold;" id="">Fatura Recibo</p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: 400; padding-bottom: 1rem;" id="viaDocumento"></p>
                            <div class="row">
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 10px; display: flex; justify-content: space-between;">
                                    <span>Documento: </span>
                                    <span id="codigoDocumentoo"></span>
                                </div>
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 10px; display: flex; justify-content: space-between;">
                                    <span>Data de Emissão: </span>
                                    <span id="dataEmissaoDocumento"></span>
                                </div>
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 10px;display: flex; justify-content: space-between;">
                                    <span>Utilizador: </span>
                                    <span id="usuarioDocumento"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="store-user" style="margin-top: .3rem; padding-bottom: 0; border-bottom: 1px solid #000;">
                <div class="col-12">
                    <div class="row pb-1">
                        <div class="col-12" style="display: flex; justify-content: center; flex-direction: column;">
                            <div class="row">
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 10px;display: flex; justify-content: space-between;">
                                    <span>Cliente: </span>
                                    <span id="clienteDocumento"></span>
                                </div>
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 8px;display: flex; justify-content: space-between;">
                                    <span>NIF: </span>
                                    <span id="nifDocumento"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="product-area" style="border: none !important">
                <table class="tabela table table-hover ttb table-sm" style="font-size: 8pt; font-family: 'Noto Sans', sans-serif; text-align: justify; margin-bottom: 0; border-top: .5px solid #000 !important; border-bottom: 0px solid transparent !important;">
                    <thead>
                        <tr style="border-width: 1px 0 0 0 !important;">
                            <td style="text-align: left;">QTD.</td>
                            <td style="text-align: left;">PRODUCTO</td>
                            <td class="col-4" style="text-align: right;">P/UNIT.</td>
                            <td class="col-4" style="text-align: right;">TOTAL</td>
                        </tr>
                    </thead>
                    <tbody id="tabelaDocumento">
                    </tbody>
                </table>
                <table class="tabela table border-0 table-hover" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify; border-top: .5px solid #000 !important; border-bottom: 0px solid transparent !important;">
                    <thead style="font-weight: 600; color: #0000000d; border-width: 1px 0 0 0 !important;">
                        <tr style="border-width: 1px 0 0 0 !important;">
                            <td style="width: 10rem;">DESIGNAÇÃO</td>
                            <td style="width: 8rem;">TAXA(%)</td>
                            <td>INCIDÊNCIA</td>
                            <td>IMPOSTO</td>
                        </tr>
                    </thead>
                    <tbody id="incidencia" style="border: 0px solid transparent !important;">

                    </tbody>
                </table>
                <table class="tabela table border-0 table-hover hidden" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify; border-top: .5px solid #000 !important; border-bottom: 0px solid transparent !important;">
                    <thead style="font-weight: 600; color: #0000000d;">
                        <tr>
                            <td style="width: 10rem;">MODO PAGAMENTO</td>
                            <td style="width: 8rem;">VALOR</td>
                        </tr>
                    </thead>
                    <tbody id="tabelaModoPagamentoDocumento" style="border: none !important">

                    </tbody>
                </table>
            </section>
            <section class="store-user mb-1" style="padding-bottom: .3rem; border-bottom: 1px solid #000; border-top: 1px solid #000;">
                <div class="col-12">
                    <div class="row">
                        <div class="col-12" style="display: flex; justify-content: center; flex-direction: column; padding-top: .3rem;">
                            <div class="row">
                                
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 10px;display: flex; justify-content: space-between;">
                                    <span>VALOR A PAGAR: </span>
                                    <span id="aPagarDocumento"></span>
                                </div>
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 10px;display: flex; justify-content: space-between;">
                                    <span>VALOR RECEBIDO: </span>
                                    <span id="recebidoDocumento"></span>
                                </div>
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 10px;display: flex; justify-content: space-between;">
                                    <span>IMPOSTOS: </span>
                                    <span id="totalImpostos"></span>
                                </div>
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 10px;display: flex; justify-content: space-between;">
                                    <span>TROCO: </span>
                                    <span id="trocoDocumento"></span>
                                </div>
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 12px;display: flex; justify-content: space-between;">
                                    <span>TOTAL: </span>
                                    <span id="totalDocumento"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="store-user" style="padding-bottom: 0; border-bottom: 1px solid #000; margin-bottom: .5rem;">
                <div class="col-12">
                    <div class="row pb-1">
                        <div class="col-12" style="display: flex; justify-content: center; flex-direction: column;">

                            <p style="font-size: 8pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: bold;">Contactos:</p>
                            <div class="row">
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 9px;display: flex; justify-content: space-between;">
                                    <span>Telefone: </span>
                                    <span id="telefoneDocumento"></span>
                                </div>
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 9px;display: flex; justify-content: space-between;">
                                    <span>Email: </span>
                                    <span id="emailDocumento"></span>
                                </div>
                                <div class="col-md-12" style="text-align: left; font-weight: bold; font-size: 9px;display: flex; justify-content: space-between;">
                                    <span></span>
                                    <span id="endereco"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="store-user" style="padding-bottom: 0;">
                <div class="col-12">
                    <div class="row pb-1">
                        <div class="col-12" style="display: flex; justify-content: center; flex-direction: column;">
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: 100;" id="hashPrograma"></p>
                            <p style="font-size: 8pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: 100;">*Obrigado e volte sempre!*</p>
                            <p style="font-size: 8pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: 100; padding: 0 1.5rem;"> Os bens/serviços foram colocados a disposição do adquirente na data e local do documento.</p>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <script src="template/plugins/jquery/jquery.min.js"></script>
    <script>
        var incideNOR = 0;
        var ipostoNOR = 0;
        var incideRED = 0;
        var ipostoRED = 0;
        var incideICB = 0;
        var ipostoICB = 0;
        var incideISE = 0;
        var ipostoISE = 0;
        var descrNOR = '';
        var descrRED = '';
        var descrICB = '';
        var descrISE = '';
        let imposto_i = 0;
        let motivo_isec = '';

        $.ajax({
            url: "../gestao/includes/read/configuracao.inc.php",
            type: "post",
            dataType: "json",
            success: function(data) {
                logotipoDocumento.src = "../gestao/images/logo/" + data[0]['valor'];
                nomeEmpresaDocumento.innerText = data[1]['valor'];
                nifempre.innerText = data[6]['valor']
                telefoneDocumento.innerText = data[4]['valor'];
                emailDocumento.innerText = data[5]['valor'];
                endereco.innerText = data[3]['valor']
                /*nifDocumento.innerText = data[6]['valor'];
                websiteDocumento.innerText = data[7]['valor'];*/
            },
            error: function(data) {
                console.log(data);
            }
        });

        function codigoDocumento(codigo, tipoDocumento) {
            console.log('codigoDocumento chamada com:', codigo, tipoDocumento);

            // Resetar variáveis de impostos
            incideNOR = 0;
            ipostoNOR = 0;
            incideRED = 0;
            ipostoRED = 0;
            incideICB = 0;
            ipostoICB = 0;
            incideISE = 0;
            ipostoISE = 0;
            descrNOR = '';
            descrRED = '';
            descrICB = '';
            descrISE = '';
            imposto_i = 0;

            // Se codigo for string com "/", extrair o número, senão usar direto
            let idDocumento = typeof codigo === 'string' && codigo.includes('/') ? codigo.split("/")[1] : codigo;

            console.log('idDocumento:', idDocumento);

            $.ajax({
                url: "../gestao/includes/read/queryDocumento.inc.php",
                type: "post",
                dataType: "json",
                data: {
                    idDocumento: idDocumento
                },
                success: function(dataDoc) {
                    console.log("Dados do documento:", dataDoc);

                    // Preencher dados do documento
                    viaDocumento.innerText = "ORIGINAL";
                    clienteDocumento.innerText = dataDoc[0]['nomeE'].toUpperCase();
                    nifDocumento.innerText = dataDoc[0]['nifE'];
                    codigoDocumentoo.innerText = dataDoc[0]['codigoDocumento'];
                    dataEmissaoDocumento.innerText = dataDoc[0]['dataDoc'];
                    usuarioDocumento.innerText = dataDoc[0]['nomeU'];
                    recebidoDocumento.innerText = parseFloat(dataDoc[0]['entregue']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                    aPagarDocumento.innerText = parseFloat(dataDoc[0]['total']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                    trocoDocumento.innerText = parseFloat(dataDoc[0]['troco']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                    totalDocumento.innerText = parseFloat(dataDoc[0]['total']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                    totalImpostos.innerText = parseFloat(dataDoc[0]['imposto']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                    hashPrograma.innerText = dataDoc[0]['hashSaft'].substring(0, 4) + "-Processado por programa válido Nº 308/AGT/2021 | Buesimples";

                    // Buscar modos de pagamento
                    $.ajax({
                        url: "../gestao/includes/read/queryDocumentoModoPagamento.inc.php",
                        type: "post",
                        dataType: "json",
                        data: {
                            idDocumento: idDocumento,
                        },
                        success: function(dataMp) {
                            console.log("dados mp")
                            console.log(dataMp)
                            let row = "";
                            for (var key in dataMp) {
                                row += `
                                <tr>
                                    <td style=" font-size: 8pt; text-align: left; border: none;">${dataMp[key]['nomeMp']}</td>
                                    <td style=" font-size: 8pt; text-align: left; border: none;">${dataMp[key]['valor'].replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                </tr>`;
                            }
                            $("#tabelaModoPagamentoDocumento").html(row);
                        }
                    });

                    // Buscar linhas do documento
                    $.ajax({
                        url: "../gestao/includes/read/queryDocumentoLinha.inc.php",
                        type: "post",
                        dataType: "json",
                        data: {
                            idDocumento: idDocumento,
                        },
                        success: function(dataLinhas) {
                            console.log('Linhas recebidas:', dataLinhas)
                            let row = "";
                            for (var key in dataLinhas) {
                                row += `
                            <tr>
                            <td style="text-align: left;">${parseInt(dataLinhas[key]['qtdAd']).toFixed(0).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                            <td style="text-align: left;">${dataLinhas[key]['descricaoAd']}</td>
                            <td style="text-align: right;">${parseFloat(dataLinhas[key]['precoAd']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                            <td style="text-align: right;">${parseFloat(dataLinhas[key]['totalAd']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                        </tr>
                            `;

                                console.log('Processando linha:', key, 'idImposto:', dataLinhas[key]['idImposto'], 'total:', dataLinhas[key]['totalAd']);

                                if (dataLinhas[key]['idImposto'] == 1) {
                                    incideNOR = Number(dataLinhas[key]['totalAd']) + incideNOR;
                                    ipostoNOR = ((Number(dataLinhas[key]['totalAd']) * 14) / 100) + ipostoNOR;
                                    descrNOR = dataLinhas[key]['nome'];
                                    console.log('NOR acumulado:', incideNOR, 'Imposto NOR:', ipostoNOR);
                                } else if (dataLinhas[key]['idImposto'] == 2) {
                                    incideRED = Number(dataLinhas[key]['totalAd']) + incideRED;
                                    ipostoRED = ((Number(dataLinhas[key]['totalAd']) * 7) / 100) + ipostoRED;
                                    descrRED = dataLinhas[key]['nome'];
                                    console.log('RED acumulado:', incideRED, 'Imposto RED:', ipostoRED);
                                } else if (dataLinhas[key]['idImposto'] == 3) {
                                    incideICB = Number(dataLinhas[key]['totalAd']) + incideICB;
                                    ipostoICB = ((Number(dataLinhas[key]['totalAd']) * 5) / 100) + ipostoICB;
                                    descrICB = dataLinhas[key]['nome'];
                                    console.log('ICB acumulado:', incideICB, 'Imposto ICB:', ipostoICB);
                                } else if (dataLinhas[key]['idImposto'] == 4) {
                                    imposto_i = dataLinhas[key]['idImposto'];
                                    incideISE = Number(dataLinhas[key]['totalAd']) + incideISE;
                                    ipostoISE = 0;
                                    descrISE = dataLinhas[key]['nome'];
                                    console.log('ISE acumulado:', incideISE);
                                }

                            }

                            $("#tabelaDocumento").html(row);
                            console.log('Tabela preenchida, a chamar buildFooter');
                        }
                    }).done(function() {
                        console.log('AJAX done - a chamar buildFooter');
                        buildFooter();
                        let soma = 0;
                        let tabela = document.querySelector('.tabela-principal');
                        for (let i = 1; i < tabela.rows.length; i++) {
                            let valor = parseInt(tabela.rows[i].cells[0].innerText);
                            soma += valor;
                        }
                        nItensDocumento.innerText = soma;
                    }).fail(function(error) {
                        console.error('Erro no AJAX queryDocumentoLinha:', error);
                    });
                },
                error: function(error) {
                    console.error('Erro ao buscar documento:', error);
                }
            });
        }

        function buildFooter() {
            console.log('Apresentando')
            let incidNew = '';
            if (descrNOR != '') {
                incidNew = `<tr>
                                <td>${descrNOR}</td>
                                <td>14</td>
                                <td>${parseFloat(incideNOR).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                <td>${parseFloat(ipostoNOR).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                            </tr>`;
            }
            if (descrRED != '') {
                incidNew += `<tr>
                                <td>${descrRED}</td>
                                <td>7</td>
                                <td>${parseFloat(incideRED).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                <td>${parseFloat(ipostoRED).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                            </tr>`;
            }
            if (descrICB != '') {
                incidNew += `<tr>
                                <td>${descrICB}</td>
                                <td>5</td>
                                <td>${parseFloat(incideICB).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                <td>${parseFloat(ipostoICB).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                            </tr>`;
            }
            if (descrISE != '') {
                if (imposto_i != 0) {
                    $.ajax({
                        url: "includes/read/queryDocumentoModoPagamento.inc.php",
                        type: "post",
                        dataType: "json",
                        data: {
                            motivo_isencao: 'motivo',
                            idImposto: imposto_i
                        },
                        success: function(data) {
                            console.log(data)
                            motivo_isec = data[0]['motivo'];
                            $('#motivo_isencao').text(motivo_isec)
                            $('#motivo_isencao').removeClass('invisible')


                        },
                        error: function(data) {

                        }
                    });
                }
                incidNew += `<tr>
                                <td>${descrISE}</td>
                                <td>0</td>
                                <td>${parseFloat(incideISE).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                <td>${parseFloat(ipostoICB).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                            </tr>`;


            }
            incidencia.innerHTML = incidNew;
        }
    </script>
</body>

</html>