<?php
require_once('../classes/database.class.php');
include("../classes/saftModel.class.php");
require_once('./xml.class.php');

$dataInicial = $_POST["dataInicial"];
$dataFinal = $_POST["dataFinal"];
$nomeFicheiro = $_POST["nomeFicheiro"];

$modelo = new SaftModel();
$empresa = $modelo->queryEmpresa();
$definicao = $modelo->queryDefinicao();
$entidade = $modelo->queryEntidade($dataInicial, $dataFinal);
$artigo = $modelo->queryArtigo($dataInicial, $dataFinal);
$tipoTaxa = $modelo->queryTipoTaxa();
$contagemDocumento = $modelo->countDocumento($dataInicial, $dataFinal);
$contagemRecibo = $modelo->countRecibo($dataInicial, $dataFinal);
$somaCredito = $modelo->sumCredito($dataInicial, $dataFinal);
$somaDebito = $modelo->sumDebito($dataInicial, $dataFinal);
$documento = $modelo->documento($dataInicial, $dataFinal);
$recibo = $modelo->recibo($dataInicial, $dataFinal);
$totalCredito = 0;
$totalDebito = 0;

$xml = new Xml();
$attributes = [
    'xmlns' => 'urn:OECD:StandardAuditFile-Tax:AO_1.01_01',
    'xmlns:xsi' => 'http://www.w3.org/2001/XMLSchema-instance',
];
$xml->abrirTagAtributo('AuditFile', $attributes);
$xml->abrirTag('Header');
$xml->adicionarTag("AuditFileVersion", "1.01_01");
$xml->adicionarTag("CompanyID", $empresa[6]['valor'] == null ? "Desconhecido" : $empresa[6]['valor']);
$xml->adicionarTag("TaxRegistrationNumber", $empresa[6]['valor'] == null ? "Desconhecido" : $empresa[6]['valor']);
$xml->adicionarTag("TaxAccountingBasis", $definicao["tipoPrograma"]);
$xml->adicionarTag("CompanyName", $empresa[1]['valor'] == null ? "Desconhecido" : $empresa[1]['valor']);
$xml->abrirTag('CompanyAddress');
$xml->adicionarValor($empresa[3]['valor'] == null ? "Desconhecido" : $empresa[3]['valor']);
$xml->adicionarTag("AddressDetail", $empresa[3]['valor'] == null ? "Desconhecido" : $empresa[3]['valor']);
$xml->adicionarTag("City", $empresa[10]['valor'] == null ? "Desconhecido" : $empresa[10]['valor']);
$xml->adicionarTag("Province", $empresa[11]['valor'] == null ? "Desconhecido" : $empresa[11]['valor']);
$xml->adicionarTag("Country", $definicao["pais"] == null ? $definicao["pais"] : $definicao["pais"]);
$xml->fecharTag('CompanyAddress');
$xml->adicionarTag("FiscalYear", $definicao["serie"] == null ? "Desconhecido" : $definicao["serie"]);
$xml->adicionarTag("StartDate", $dataInicial == null ? "Desconhecido" : $dataInicial);
$xml->adicionarTag("EndDate", $dataFinal == null ? "Desconhecido" : $dataFinal);
$xml->adicionarTag("CurrencyCode", $definicao["moeda"] == null ? "Desconhecido" : $definicao["moeda"]);
$xml->adicionarTag("DateCreated", date('Y-m-d') == null ? "Desconhecido" : date('Y-m-d'));
$xml->adicionarTag("TaxEntity", "Global");
$xml->adicionarTag("ProductCompanyTaxID", "AO5417432466");
$xml->adicionarTag("SoftwareValidationNumber", "0/AGT/2021");
$xml->adicionarTag("ProductID", "BUESIMPLES/MAYONGI ANGOLA");
$xml->adicionarTag("ProductVersion", "1");
$xml->fecharTag('Header');
$xml->abrirTag("MasterFiles");

for ($i = 0; $i < count($entidade); $i++) {
    $xml->abrirTag("Customer");
    $xml->adicionarTag("CustomerID", $entidade[$i]["idEntidade"]);
    $xml->adicionarTag("AccountID", "Desconhecido");
    $xml->adicionarTag("CustomerTaxID", $entidade[$i]["nif"]);
    $xml->adicionarTag("CompanyName", $entidade[$i]["nome"]);
    $xml->abrirTag("BillingAddress");
    $xml->adicionarTag("AddressDetail", $entidade[$i]["morada"] == null ? "Desconhecido" : $entidade[$i]["morada"]);
    $xml->adicionarTag("City", $entidade[$i]["cidade"] == null ? "Desconhecido" : $entidade[$i]["cidade"]);
    $xml->adicionarTag("Province", $entidade[$i]["provincia"] == null ? "Desconhecido" : $entidade[$i]["provincia"]);
    $xml->adicionarTag("Country", $entidade[$i]["pais"] == null ? $definicao["pais"] : $entidade[$i]["pais"]);
    $xml->fecharTag("BillingAddress");
    $xml->adicionarTag("SelfBillingIndicator", "0");
    $xml->fecharTag("Customer");
}

for ($i = 0; $i < count($artigo); $i++) {
    $xml->abrirTag("Product");
    $xml->adicionarTag("ProductType", $artigo[$i]["tipoArtigo"] == null ? "Desconhecido" : $artigo[$i]["tipoArtigo"]);
    $xml->adicionarTag("ProductCode", $artigo[$i]["idArtigo"] == null ? "Desconhecido" : $artigo[$i]["idArtigo"]);
    $xml->adicionarTag("ProductDescription", $artigo[$i]["nome"] == null ? "Desconhecido" : $artigo[$i]["nome"]);
    $xml->adicionarTag("ProductNumberCode", $artigo[$i]["idArtigo"] == null ? "Desconhecido" : $artigo[$i]["idArtigo"]);
    $xml->fecharTag("Product");
}
$xml->abrirTag("TaxTable");
for ($i = 0; $i < count($tipoTaxa); $i++) {

    $xml->abrirTag("TaxTableEntry");
    $xml->adicionarTag("TaxType", $tipoTaxa[$i]["codigoTipoTaxa"] == null ? "Desconhecido" : $tipoTaxa[$i]["codigoTipoTaxa"]);
    $xml->adicionarTag("TaxCountryRegion", $tipoTaxa[$i]["designacaoPais"] == null ? "Desconhecido" : $tipoTaxa[$i]["designacaoPais"]);
    $xml->adicionarTag("TaxCode", $tipoTaxa[$i]["codigoTaxaImposto"] == null ? "Desconhecido" : $tipoTaxa[$i]["codigoTaxaImposto"]);
    $xml->adicionarTag("Description", $tipoTaxa[$i]["nomeCodigoTaxa"] == null ? "Desconhecido" : $tipoTaxa[$i]["nomeCodigoTaxa"]);
    $xml->adicionarTag("TaxPercentage", $tipoTaxa[$i]["taxaImposto"] == null ? "Desconhecido" : $tipoTaxa[$i]["taxaImposto"]);
    $xml->fecharTag("TaxTableEntry");
}
$xml->fecharTag("TaxTable");
$xml->fecharTag("MasterFiles");

for ($i = 0; $i < count($documento); $i++) {
    $totalCredito += $documento[$i]["totalLiquido"];
    $totalDebito -= $documento[$i]["totalLiquido"];
}

$xml->abrirTag("SourceDocuments");
$xml->abrirTag("SalesInvoices");
$xml->adicionarTag("NumberOfEntries", $contagemDocumento[0]["contador"] == null ? 0 : $contagemDocumento[0]["contador"]);
$xml->adicionarTag("TotalDebit", 0);
$xml->adicionarTag("TotalCredit", $somaCredito[0]["soma"]);
for ($i = 0; $i < count($documento); $i++) {
    $xml->abrirTag("Invoice");
    $xml->adicionarTag("InvoiceNo", $documento[$i]["codigoDocumento"]);
    $xml->abrirTag("DocumentStatus");
    $xml->adicionarTag("InvoiceStatus", $documento[$i]["estadoEmissao"] == 1 ? "N" : "A");
    $xml->adicionarTag("InvoiceStatusDate", date("Y-m-d", strtotime($documento[$i]["dataDoc"])) . "T" . date("H:i:s", strtotime($documento[$i]["dataDoc"])));
    $xml->adicionarTag("SourceID", $documento[$i]["idUsuario"] == null ? "Desconhecido" : $documento[$i]["idUsuario"]);
    $xml->adicionarTag("SourceBilling", "P");
    $xml->fecharTag("DocumentStatus");
    $xml->adicionarTag("Hash", $documento[$i]["hashSaft"]);
    $xml->adicionarTag("HashControl", "1");
    $xml->adicionarTag("Period", date("m", strtotime($documento[$i]["dataDoc"])));
    $xml->adicionarTag("InvoiceDate", date("Y-m-d", strtotime($documento[$i]["dataDoc"])));
    $xml->adicionarTag("InvoiceType", $documento[$i]["idTipoDoc"] == 1 ? "FT" : ($documento[$i]["idTipoDoc"] == 2 ? "FR" : ($documento[$i]["idTipoDoc"] == 7 ? "NC" : ($documento[$i]["idTipoDoc"] == 8 ?: "ND"))));
    $xml->abrirTag("SpecialRegimes");
    $xml->adicionarTag("SelfBillingIndicator", "0");
    $xml->adicionarTag("CashVATSchemeIndicator", "0");
    $xml->adicionarTag("ThirdPartiesBillingIndicator", "0");
    $xml->fecharTag("SpecialRegimes");
    $xml->adicionarTag("SourceID", "1");
    $xml->adicionarTag("SystemEntryDate", date("Y-m-d", strtotime($documento[$i]["dataDoc"])) . "T" . date("H:i:s", strtotime($documento[$i]["dataDoc"])));
    $xml->adicionarTag("CustomerID",  $documento[$i]["idEntidade"]);
    $xml->abrirTag("ShipTo");
    $xml->abrirTag("Address");
    $xml->adicionarTag("AddressDetail",  $documento[$i]["moradaE"] == null ? "Desconhecido" : $documento[$i]["moradaE"]);
    $xml->adicionarTag("City",  $documento[$i]["cidadeE"] == null ? "Desconhecido" : $documento[$i]["cidadeE"]);
    $xml->adicionarTag("Province",  $documento[$i]["provinciaE"] == null ? "Desconhecido" : $documento[$i]["provinciaE"]);
    $xml->adicionarTag("Country",  $documento[$i]["paisE"] == null ? $definicao["pais"] : $documento[$i]["paisE"]);
    $xml->fecharTag("Address");
    $xml->fecharTag("ShipTo");
    $xml->abrirTag("ShipFrom");
    $xml->abrirTag("Address");
    $xml->adicionarTag("AddressDetail", $empresa[3]['valor'] == null ? "Desconhecido" : $empresa[3]['valor']);
    $xml->adicionarTag("City", $empresa[10]['valor'] == null ? "Desconhecido" : $empresa[10]['valor']);
    $xml->adicionarTag("Province", $empresa[11]['valor'] == null ? "Desconhecido" : $empresa[11]['valor']);
    $xml->adicionarTag("Country", $definicao["pais"] == null ? $definicao["pais"] : $definicao["pais"]);
    $xml->fecharTag("Address");
    $xml->fecharTag("ShipFrom");
    $xml->adicionarTag("MovementEndTime", date("Y-m-d", strtotime($documento[$i]["dataDoc"])) . "T" . date("H:i:s", strtotime($documento[$i]["dataDoc"])));
    $xml->adicionarTag("MovementStartTime", date("Y-m-d", strtotime($documento[$i]["dataDoc"])) . "T" . date("H:i:s", strtotime($documento[$i]["dataDoc"])));
    $linha = $modelo->linhaDocumento($documento[$i]["idDocumento"]);
    for ($j = 0; $j < count($linha); $j++) {
        $xml->abrirTag("Line");
        $xml->adicionarTag("LineNumber", $j + 1);
        $xml->adicionarTag("ProductCode", $linha[$j]["idArtigo"]);
        $xml->adicionarTag("ProductDescription", $linha[$j]["descricaoAd"]);
        $xml->adicionarTag("Quantity", $linha[$j]["qtd"]);
        $xml->adicionarTag("UnitOfMeasure", $linha[$j]["nomeUm"]);
        $xml->adicionarTag("UnitPrice", $linha[$j]["preco"]);
        $xml->adicionarTag("TaxPointDate", $linha[$j]["dataDocumentoAd"]);
        $xml->adicionarTag("Description", $linha[0]["descricaoAd"] == null ? "Desconhecido" : $linha[0]["descricaoAd"]);
        $xml->adicionarTag("CreditAmount", $linha[0]["total"] == null ? "Desconhecido" : $linha[0]["total"]);
        $xml->abrirTag("Tax");
        $xml->adicionarTag("TaxType", $linha[$j]["tipoTaxatt"]);
        $xml->adicionarTag("TaxCountryRegion", $linha[$j]["codigo"]);
        $xml->adicionarTag("TaxCode", $linha[$j]["codigoTaxa"]);
        $xml->adicionarTag("TaxPercentage", $linha[$j]["taxa"]);
        $xml->fecharTag("Tax");
        $xml->adicionarTag("TaxExemptionReason", $linha[$j]["motivoIsencao"]);
        $xml->adicionarTag("TaxExemptionCode", $linha[$j]["codigoMotivoIsencao"]);
        $xml->adicionarTag("SettlementAmount", $linha[$j]["imposto"]);
        $xml->fecharTag("Line");
    }

    $xml->abrirTag("DocumentTotals");
    $xml->adicionarTag("TaxPayable", $documento[$i]["imposto"] == null ? "Desconhecido" : $documento[$i]["imposto"]);
    $xml->adicionarTag("NetTotal", $documento[$i]["totalLiquido"] == null ? "Desconhecido" : $documento[$i]["totalLiquido"]);
    $xml->adicionarTag("GrossTotal", $documento[$i]["total"] == null ? "Desconhecido" : $documento[$i]["total"]);
    $modoPagamento = $modelo->modoPagamento($documento[$i]["idDocumento"]);
    if (count($modoPagamento) > 0) {
        for ($j = 0; $j < count($modoPagamento); $j++) {
            $xml->abrirTag("Payment");
            $xml->adicionarTag("PaymentMechanism", $modoPagamento[$j]["mecanismoPagamento"]);
            $xml->adicionarTag("PaymentAmount", $modoPagamento[$j]["valor"]);
            $xml->adicionarTag("PaymentDate", date("Y-m-d", strtotime($recibo[$i]["dataDoc"])));
            $xml->fecharTag("Payment");
        }
    }
    $xml->fecharTag("DocumentTotals");
    $xml->fecharTag("Invoice");
}
$xml->fecharTag("SalesInvoices");

$xml->abrirTag("Payments");
$xml->adicionarTag("NumberOfEntries", $contagemRecibo[0]["contador"] == null ? 0 : $contagemRecibo[0]["contador"]);
$xml->adicionarTag("TotalDebit", 0);
$xml->adicionarTag("TotalCredit", $somaDebito[0]["soma"]);
for ($i = 0; $i < count($recibo); $i++) {
    $xml->abrirTag("Payment");
    $xml->adicionarTag("PaymentRefNo", $recibo[$i]["codigoDocumento"]);
    $xml->adicionarTag("Period", date("m", strtotime($recibo[$i]["dataDoc"])));
    $xml->adicionarTag("TransactionDate", date("Y-m-d", strtotime($recibo[$i]["dataDoc"])));
    $xml->adicionarTag("PaymentType", "RC");
    $xml->abrirTag("DocumentStatus");
    $xml->adicionarTag("PaymentStatus", $recibo == 1 ? "N" : "A");
    $xml->adicionarTag("PaymentStatusDate", date("Y-m-d", strtotime($recibo[$i]["dataDoc"])) . "T" . date("H:i:s", strtotime($recibo[$i]["dataDoc"])));
    $xml->adicionarTag("SourceID", $recibo[$i]["idUsuario"] == null ? "Desconhecido" : $recibo[$i]["idUsuario"]);
    $xml->adicionarTag("SourcePayment", "P");
    $xml->fecharTag("DocumentStatus");
    $modoPagamentoRecibo = $modelo->modoPagamento($recibo[$i]["idDocumento"]);
    if (count($modoPagamentoRecibo) > 0) {
        for ($j = 0; $j < count($modoPagamentoRecibo); $j++) {
            $xml->abrirTag("PaymentMethod");
            $xml->adicionarTag("PaymentMechanism", $modoPagamentoRecibo[$j]["mecanismoPagamento"]);
            $xml->adicionarTag("PaymentAmount", $modoPagamentoRecibo[$j]["valor"]);
            $xml->adicionarTag("PaymentDate", date("Y-m-d", strtotime($recibo[$i]["dataDoc"])));
            $xml->fecharTag("PaymentMethod");
        }
    }
    $xml->adicionarTag("SourceID", $recibo[$i]["idUsuario"] == null ? "Desconhecido" : $recibo[$i]["idUsuario"]);
    $xml->adicionarTag("SystemEntryDate", date("Y-m-d", strtotime($recibo[$i]["dataDoc"])) . "T" . date("H:i:s", strtotime($recibo[$i]["dataDoc"])));
    $xml->adicionarTag("CustomerID", $recibo[$i]["idEntidade"]);
    $queryFactura = $modelo->queryDocumentoFac($recibo[$i]["idDocumento"], 1);
    for ($j = 0; $j < count($queryFactura); $j++) {
        $xml->abrirTag("Line");
        $xml->adicionarTag("LineNumber", $j + 1);
        $xml->abrirTag("SourceDocumentID");
        $xml->adicionarTag("OriginatingON", $queryFactura[$j]["codigoDocumento"]);
        $xml->adicionarTag("InvoiceDate", date("Y-m-d", strtotime($queryFactura[$j]["dataDoc"])));
        $xml->fecharTag("SourceDocumentID");
        $xml->adicionarTag("CreditAmount", $queryFactura[$j]["entregueDocRelac"]);
        $xml->fecharTag("Line");
    }
    $xml->abrirTag("DocumentTotals");
    $xml->adicionarTag("TaxPayable", $recibo[$i]["imposto"] == null ? "Desconhecido" : $recibo[$i]["imposto"]);
    $xml->adicionarTag("NetTotal", $recibo[$i]["totalLiquido"] == null ? "Desconhecido" : $recibo[$i]["totalLiquido"]);
    $xml->adicionarTag("GrossTotal", $recibo[$i]["total"] == null ? "Desconhecido" : $recibo[$i]["total"]);
    $xml->fecharTag("DocumentTotals");
    $xml->fecharTag("Payment");
}
$xml->fecharTag("Payments");

$xml->fecharTag("SourceDocuments");
$xml->fecharTag("AuditFile");

$xml->gravarFicheiro("./ficheiro/" . $nomeFicheiro . ".xml");
echo json_encode($xml);