<?php include('./header.php'); ?>
<style type="text/css">
    .logo img {
        width: 150px;
    }

    .container .form-outer {
        width: 100%;
        overflow: hidden;
    }

    .form-outer .formulario {
        display: flex;
        width: 400%;
    }

    .form-outer .formulario .page {
        width: 25%;
        transition: margin-left 0.3s ease-in-out;
    }

    .form-outer .formulario .page .field {
        display: flex;
    }

    .form-outer .formulario .page .field button:hover {
        background-color: #66009f;
        border-color: #66009f;
    }

    .form-outer .formulario .page .field button {
        background-color: #560085;
        border-color: #560085;
    }

    .formulario .page .btns button.prev {
        margin-right: 3px !important;
        font-size: 17px;
    }

    .formulario .page .btns button.next {
        margin-left: 3px !important;
    }

    .container .progress-barra {
        display: flex;
        justify-content: space-between;
    }

    .container .progress-barra .step {
        position: relative;
        text-align: center;
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
    }

    .progress-barra .step p {
        font-size: 14px;
        font-weight: 500;
        color: #666;
        margin-bottom: 8px;
        transition: 0.2s;
    }

    .progress-barra .step p.active {
        color: #560085;
    }

    .progress-barra .step .bullet {
        position: relative;
        height: 35px;
        width: 35px;
        border: 2px solid #666;
        display: inline-block;
        border-radius: 50%;
        transition: 0.2s;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .progress-barra .step .bullet.active {
        border-color: #560085;
        background: #560085;
    }

    .progress-barra .step .bullet span {
        font-weight: 500;
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
    }

    .progress-barra .step .bullet.active span {
        display: none;
    }

    .progress-barra .step:last-child .bullet:before,
    .progress-barra .step:last-child .bullet:after {
        display: none;
    }

    .progress-barra .step .bullet:before,
    .progress-barra .step .bullet:after {
        position: absolute;
        content: '';
        right: -14.35rem;
        height: 3px;
        width: 14rem;
        background: #666;
    }

    .progress-barra .step .bullet.active:after {
        background: #560085;
        transform: scaleX(0);
        transform-origin: left;
        animation: animate 0.3s linear forwards;
    }

    @keyframes animate {
        100% {
            transform: scaleX(1);
        }
    }

    .progress-barra .step .check {
        position: absolute;
        font-size: 15px;
        color: #666;
        display: none;
    }

    .progress-barra .step .check.active {
        display: block;
        color: #fff;
    }
</style>

<body class="hold-transition layout-top-nav">
    <div class="wrapper">
        <div class="preloader flex-column justify-content-center align-items-center">
        </div>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <div class="content-header">
                <div class="container-fluid">
                </div><!-- /.container-fluid -->
            </div>
            <!-- /.content-header -->

            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <!-- SELECT2 EXAMPLE -->
                        <div class="col-md-12">
                            <div class="card card-default">
                                <div class="card-body button-nav">
                                    <div class="row float-right">
                                        <div class="col-md-12">
                                            <button class="btn btn-opcao" id="btn-preview" disabled>Pré-visualizar</button>
                                            <button class="btn btn-opcao">Importar</button>
                                            <button class="btn btn-opcao botao-activo" id="btn">Nova Classe de Movimento</button>
                                        </div>
                                    </div>
                                    <!-- /.row -->
                                </div>
                                <!-- /.card-body -->
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="card card-default">
                                <div class="card-header">
                                    <h3 class="card-title">Listagem de Classe de Movimentos</h3>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <!-- /.card-header -->
                                <div class="card-body">
                                    <table id="tabelaClasseMovimento" class="table table-bordered table-striped" style="line-height: 0.8;">
                                        <thead>
                                            <tr style="text-align: center;">
                                                <th title="Identificador do Família">Ref. Classe Mov.</th>
                                                <th title="Tipo de Moviemtno">Tipo Movimento</th>
                                                <th title="Descrição da Classe">Descrição</th>
                                                <th title="Código Classe">Código</th>
                                                <th title="Responsável Classe">Responsável</th>
                                                <th title="Opções"><i class="fa-solid fa-screwdriver-wrench"></i></th>
                                            </tr>
                                        </thead>
                                        <tbody id="corpoTabela" style="text-align: center;">

                                        </tbody>
                                    </table>
                                </div>
                                <!-- /.card-body -->
                                <div class="card-footer">
                                    Listagem das Classes de Movimentos.
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.container-fluid -->
            </section>
            <div class="modal fade" id="modal-documento">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <div class="container">
                                <div class="progress-barra">
                                    <div class="step">
                                        <p style="margin: 0;">Formulário de Classe de Movimento</p>
                                    </div>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="close">
                                        <small aria-hidden="true">
                                            <small class="fas fa-close"></small>
                                        </small>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="modal-body">
                            <div class="container">
                                <div class="card-body form-outer" style="padding: 0;">
                                    <div class="formulario">
                                        <div class="page slidePage">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <h5 style="margin-bottom: 0rem; justify-content: center;">
                                                        <span id="doOpcao"></span> - <span id="codigo"></span>
                                                    </h5>
                                                    <div class="row">
                                                        <div class="col-md-10"></div>
                                                        <div class="col-md-12">
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="not-required">Tipo de Movimento</small>
                                                                <select name="" id="tipomovimento" class="form-control">
                                                                    <option value="">-- Selecione o tipo de Movimento --</option>
                                                                    <option value="1">Crédito</option>
                                                                    <option value="2">Débito</option>
                                                                </select>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Código Movimento</small>
                                                                <input type="text" class="form-control" id="codigomovimento" name="nome" placeholder="Código" title="Descrição" required>
                                                                <small>Mensagem de erro</small>
                                                            </div>

                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Descrição</small>
                                                                <textarea type="text" class="form-control" id="descricaomovimento" name="descricao" placeholder="Descrição" title="Descrição" required></textarea>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-12" style=" bottom: 0; padding-top: 14px;">
                                                    <div class="form-group margem">
                                                        <small>Mensagem de erro</small>
                                                        <div class="form-group field btns">
                                                            <button class="btn btn-block btn-primary submit next" id="gravarclassemovimento" style="margin-top: 0;">
                                                                Gravar Classe Movimento
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer d-none">
                            <div class="col-md-12" id="footerPagamento" style="opacity: 0;">
                                <h4 style="display: flex; align-items: center; justify-content: space-between;"><span id="totalEntregue">ENTREGUE</span><span id="entregueSpan">0,00 Kzs</span></h4>
                                <h4 style="display: flex; align-items: center; justify-content: space-between;"><span class="text-danger" id="totalText">TOTAL</span><span class="text-danger" id="totalSpan">0,00 Kzs</span></h4>
                            </div>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <div class="modal fade" id="modal-documento-update">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <div class="container">
                                <div class="progress-barra">
                                    <div class="step">
                                        <p style="margin: 0;">Formulário de Classe de Movimento</p>
                                    </div>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="close">
                                        <small aria-hidden="true">
                                            <small class="fas fa-close"></small>
                                        </small>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="modal-body">
                            <div class="container">
                                <div class="card-body form-outer" style="padding: 0;">
                                    <div class="formulario">
                                        <div class="page slidePage">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <h5 style="margin-bottom: 0rem; justify-content: center;">
                                                        <span id="doOpcao"></span> - <span id="codigo"></span>
                                                    </h5>
                                                    <div class="row">
                                                        <div class="col-md-10"></div>
                                                        <div class="col-md-12">
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <input type="hidden" id="id_classe_movimento" value="0" name="">
                                                                <small class="not-required">Tipo de Movimento</small>
                                                                <select name="" id="tipomovimento-update" class="form-control">
                                                                    <option value="">-- Selecione o tipo de Movimento --</option>
                                                                    <option value="1">Crédito</option>
                                                                    <option value="2">Débito</option>
                                                                </select>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Código Movimento</small>
                                                                <input type="text" class="form-control" id="codigomovimento-update" name="nome" placeholder="Código" title="Descrição" required>
                                                                <small>Mensagem de erro</small>
                                                            </div>

                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Descrição</small>
                                                                <textarea type="text" class="form-control" id="descricaomovimento-update" name="descricao" placeholder="Descrição" title="Descrição" required></textarea>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-12" style=" bottom: 0; padding-top: 14px;">
                                                    <div class="form-group margem">
                                                        <small>Mensagem de erro</small>
                                                        <div class="form-group field btns">
                                                            <button class="btn btn-block btn-primary submit next" id="updateclassemovimento" style="margin-top: 0;">
                                                                Atualizar Classe Movimento
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer d-none">
                            <div class="col-md-12" id="footerPagamento" style="opacity: 0;">
                                <h4 style="display: flex; align-items: center; justify-content: space-between;"><span id="totalEntregue">ENTREGUE</span><span id="entregueSpan">0,00 Kzs</span></h4>
                                <h4 style="display: flex; align-items: center; justify-content: space-between;"><span class="text-danger" id="totalText">TOTAL</span><span class="text-danger" id="totalSpan">0,00 Kzs</span></h4>
                            </div>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <div class="modal fade d-none" id="modal-cliente">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Entidades</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <table id="tabelaCliente" class="table table-hover table-bordered table-striped" style="line-height: 0.8;">
                                <thead>
                                    <tr style="text-align: center;">
                                        <th title="Identificador da Entidade">Ref. Entidade</th>
                                        <th title="Nome">Nome</th>
                                        <th title="Nome Comercial">Nome Comercial</th>
                                        <th title="Bilhete de Identidade do Cliente">B.I</th>
                                        <th title="NIF do Cliente">NIF</th>
                                        <th title="Localidade do Cliente">Localidade</th>
                                        <th title="Data de Nascimento do Cliente">Data Nasc.</th>
                                        <th title="Morada do Cliente">Morada</th>
                                        <th title="Tipo">Tipo</th>
                                        <th title="Estado do Cliente">Estado</th>
                                    </tr>
                                </thead>
                                <tbody style="text-align: center;">
                                </tbody>
                            </table>
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
                            <button type="button" class="btn btn-primary">Confirmar</button>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <div class="modal fade d-none" id="modal-artigo">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Artigos</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <table id="tabelaArtigoListagem" class="table table-hover table-bordered table-striped" style="line-height: 0.8;">
                                <thead>
                                    <tr style="text-align: center;">
                                        <th title="Referência">Referência</th>
                                        <th title="Descrição do Artigo">Descrição</th>
                                        <th title="Família">Família</th>
                                        <th title="Preço do Artigo (S/Imp)">Preço (S/Imp)</th>
                                        <th title="Preço do Artigo (C/Imp)">Preço (C/Imp)</th>
                                        <th title="Qtd. Stock">Qtd. Stock</th>
                                    </tr>
                                </thead>
                                <tbody style="text-align: center;">
                                </tbody>
                            </table>
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
                            <button type="button" class="btn btn-primary">Confirmar</button>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
        </div>
        <div class="modal fade d-none" id="modal-updateUsuario">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header" style="padding: 0.5rem;">
                        <h3 class="card-title p-3">Família: <span id="nomeModal"></span></h3>
                    </div>
                    <div class="modal-body" style="padding-bottom: 0px;">
                        <div class="row">
                            <div class="col-md-12">
                                <form name="tabelaInfo">
                                    <table name="tabelaInfo" class="table table-sm table-bordered" style="min-width: 100%; max-width: 100%;">
                                        <tr name="linhaItem">
                                            <td style="padding: 20px 0px 0px 10px;">
                                                <p>Ref. da Família: <span id="codigoInfo"></span></p>
                                                <p>Descrição: <span id="nomeInfo"></span></p>
                                                <p>Observações: <span id="notaInfo"></span></p>
                                            </td>
                                        </tr>
                                    </table>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <!-- /.content-wrapper -->
        <?php include('footer.php'); ?>
</body>

</html>

<script>
    $('#btn').click(function() {
        $('#modal-documento').modal('show');
        $('#doOpcao').html('Classe Movimento');
        $('#codigo').html('2024/1');
    });

    funcaoSelect("../pos/includes/select.inc.php", "post", "json", "viewclassemovimento", function success(data) {
        console.log(data)
                $("#tabelaClasseMovimento").DataTable({
                    select: 'single',
                    "aaData": data,
                    "columns": [{
                      data: "idClassemovimento"
                    }, {
                      data: "tipo"
                    }, {
                      data: "descricao"
                    }, {
                      data: "codigo"
                    }, {
                      data: "responsavel"
                    }, {
                      data: null,
                      render: function(data, type, row) {
                        return `
                        <div id="dropdownOpcoes" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="display:flex; align-items: center; justify-content: space-around;"><button class="btn btn-outline-primary opcoes" style="padding: .2rem .7rem; line-height: 1; border: none;"><i class="fa-solid fa-ellipsis-vertical"></i></button></div>
                        <ul aria-labelledby="dropdownOpcoes" class="dropdown-menu border-0 shadow">
                          <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-more" style="padding: .8rem; border-radius: 5px;">Informações</a></li>
                          <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-update" style="padding: .8rem; border-radius: 5px;">Editar</a></li>
                          <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-delete" style="padding: .8rem; border-radius: 5px;">Eliminar</a></li>
                        </ul>`;
                      }
                    }],
                    columnDefs: [{
                      targets: -1,
                      orderable: false
                    }],
                    "responsive": true,
                    "lengthChange": false,
                    "autoWidth": false,
                    "language": idiomaPortugues,
                    lengthMenu: [
                      [7, 25, 50, -1],
                      [10, 25, 50, 'All']
                    ],
                    "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                  }).buttons().container().appendTo('#tabelaClasseMovimento_wrapper .col-md-6:eq(0)');
        },
        function error(data) {
            erro(data);
        },
        function done(data) {
            
        });

    $('#tabelaClasseMovimento').on('click', '.btn-update', function(e) {
   /* e.preventDefault();
    linha = $(this).closest('tr').find('td');
    doOpcao.innerText = "Editar Artigo";
    resetForm();
    $('#modal-documento').modal('show');*/
    let id = $(this).closest('tr').find('td')[0].textContent;
    alert(id)
    $('#modal-documento-update').modal('show');
    detalhes(id)
    function detalhes(id) {
    funcaoQuerySelect("../pos/includes/querySelect.inc.php", "post", "json", {
      idClassemovimento: id
    }, "classemovimento", function success(data) {
        console.log(data)
      for (var key in data) {
        $('#id_classe_movimento').val(id);
        console.log(data[key]["tipo"])
        $('#tipomovimento-update').val(data[key]["tipomovimento"]);
        $('#codigomovimento-update').val(data[key]["codigo"]);
        $('#descricaomovimento-update').val(data[key]["descricao"]);
      }
    }, function error(data) {

    }, function done(data) {

    });
  }

  
  });

  $('#tabelaClasseMovimento').on('click', '.btn-delete', function(e) {
   /* e.preventDefault();
    linha = $(this).closest('tr').find('td');
    doOpcao.innerText = "Editar Artigo";
    resetForm();
    $('#modal-documento').modal('show');*/
    let id = $(this).closest('tr').find('td')[0].textContent;
    funcaoDelete("../pos/includes/delete.inc.php", "post", "json", "classemovimento", {
            idClassemovimento: id
          }, function success(data) {
            console.log(data);
            swal.fire({
              title: "Dados eliminado com sucesso!",
              icon: "success",
              confirmButtonText: 'Confirmar',
              confirmButtonColor: '#560085',
            });
            window.location.href ="formParametroClasseMovimento.php"
          }, function error(data) {
            console.log(data);
            swal.fire({
              title: "Erro ao eliminar Tipo de Usuário!",
              text: "Tipo de Usuário associado a uma ou mais Documentos.",
              icon: "error",
              confirmButtonText: 'Confirmar',
              confirmButtonColor: '#560085',
            });
          }, function done(data) {

          });

  
  });    


    $('#updateclassemovimento').click(function(e){
        var id_classe_movimento = $('#id_classe_movimento').val();
        var tipomovimento = $('#tipomovimento-update').val();
        var codigomovimento = $('#codigomovimento-update').val();
        var descricaomovimento = $('#descricaomovimento-update').val();



        let currentObjectData = {
                    responsavel: <?php echo "'". strtoupper($_SESSION["usuarioNome"])."'"; ?>,
                    tipomovimento: tipomovimento,
                    descricao : descricaomovimento,
                    codigo: codigomovimento,
            }

        if (tipomovimento != null && (descricaomovimento != null && descricaomovimento != '')) {
            funcaoUpdate("../pos/includes/update.inc.php", "post", "json", "classemovimento", currentObjectData, {
                    idClassemovimento: id_classe_movimento
                  }, function success(data) {
                    swal.fire({
                      title: "Feito!",
                      text: "Informações Actualizadas com sucesso!",
                      confirmButtonText: 'Confirmar',
                      confirmButtonColor: '#560085',
                      icon: "success",
                    });
                    window.location.href ="formParametroClasseMovimento.php"
                  }, function error(data) {
                    console.log("Erro: ", data);
                    swal.fire({
                      title: "Erro ao actualizar!",
                      text: "Erro ao actualizar Dados Submetidos!",
                      confirmButtonText: 'Confirmar',
                      confirmButtonColor: '#560085',
                      icon: "error",
                    });
                  }, function done(data) {

                });
            }else{
                
            }

        });

    $('#gravarclassemovimento').click(function(e){




        var tipomovimento = $('#tipomovimento').val();
        var codigomovimento = $('#codigomovimento').val();
        var descricaomovimento = $('#descricaomovimento').val();

        let currentObjectData = {
                    responsavel: <?php echo "'". strtoupper($_SESSION["usuarioNome"])."'"; ?>,
                    tipomovimento: tipomovimento,
                    descricao : descricaomovimento,
                    codigo: codigomovimento,
            }

        if (tipomovimento != null && (descricaomovimento != null && descricaomovimento != '')) {
            funcaoInsert("../pos/includes/insert.inc.php", "post", "json", 'classemovimento', currentObjectData, function success(data) {}, function error(data) {
                console.log(data)
                     swal.fire({
                        title: "Erro ao cadastrar!",
                        text: "Erro ao cadastrar coordenadas! ",//+ nome.value + " !",
                        confirmButtonText: 'Confirmar',
                        confirmButtonColor: '#560085',
                        icon: "error",
                     });
                  }, function done(data) {
                     swal.fire({
                        title: "Cadatrado",
                        text: "Os dados Submetidos foram cadastrados com sucesso!",
                        icon: "success",
                        confirmButtonText: 'Confirmar',
                        confirmButtonColor: '#560085',
                     });
                     window.location.href ="formParametroClasseMovimento.php"
                  });
            }

        });

</script>

<script src=""></script>