<?php $page = 'familia';
include('header.php'); ?>

<body class="hold-transition layout-top-nav">
  <div class="wrapper">
    <div class="preloader flex-column justify-content-center align-items-center">
    </div>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- SELECT2 EXAMPLE -->
            <div class="col-md-8 mx-auto">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">Configurações Empresa</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-3" style="text-align: -webkit-center;">
                      <div class="form-group margem">
                        <div class="wrapper-image">
                          <div class="image-container">
                            <i class="fas fa-image"></i>
                          </div>
                          <label for="file" class="camera-icon">
                            <i class="fas fa-camera"></i>
                          </label>
                          <input type="file" id="file" name="file" accept="image/*" hidden>
                        </div>
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Nome da Empresa</small>
                        <input type="text" class="form-control" id="titulo" name="titulo" placeholder="Nome da Empresa" title="Nome da Empresa" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Endereço</small>
                        <input type="text" class="form-control" id="endereco" name="endereco" placeholder="Endereço" title="Endereço" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">E-mail</small>
                        <input type="text" class="form-control" id="email" name="email" placeholder="E-mail" title="E-mail" required>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group" style="margin-bottom: 0;">
                        <!--<label>Género</label>-->
                        <small class="required">Categoria da Empresa</small>
                        <select class="form-control select2" style="width: 100%;" id="categoriaEmpresa" name="categoriaEmpresa">
                          <option value="0">Selecione a Categoria da Empresa</option>
                          <option value="Fornecedor">Fornecedor</option>
                          <option value="Aplicador">Aplicador</option>
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Número de Telefone</small>
                        <input type="text" class="form-control" id="telefone" name="telefone" placeholder="Telefone" title="Telefone" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">NIF (Número de Identificação Fiscal)</small>
                        <input type="text" class="form-control" id="nif" name="nif" placeholder="NIF (Número de Identificação Fiscal)" title="NIF (Número de Identificação Fiscal)" required>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">URL do Website</small>
                        <input type="text" class="form-control" id="site" name="site" placeholder="URL do Website" title="URL do Website" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Rodapé</small>
                        <input type="text" class="form-control" id="rodape" name="rodape" placeholder="Rodapé do Website" title="Rodapé do Website" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small>Botão</small>
                        <button class="btn btn-block btn-primary" id="btn-submit" name="btn-submit">Gravar Alterações</button>
                      </div>
                    </div>
                    <!-- /.col -->
                  </div>
                  <!-- /.row -->
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                  Configurações da empresa.
                </div>
              </div>
            </div>
          </div>
          <!-- /.card -->
        </div>
        <!-- /.container-fluid -->
      </section>
    </div>
    <!-- /.content-wrapper -->
    <?php include('footer.php'); ?>
</body>

</html>
<script>
  $(document).ready(function() {
    zeroButton();
  });
  $(document).ready(function() {
    $.ajax({
      url: "includes/read/queryConfiguracao.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        console.log(data);
        img = document.querySelector(".image-container");
        titulo = document.getElementById("titulo");
        let rodape = document.getElementById("rodape");
        endereco = document.getElementById("endereco");
        telefone = document.getElementById("telefone");
        email = document.getElementById("email");
        nif = document.getElementById("nif");
        site = document.getElementById("site");

        $('#categoriaEmpresa').val(data[8]['valor']);
        $('#categoriaEmpresa').select2().trigger('change');

        console.log("Está aqui a imagem: ", img);
        img.style.backgroundImage = "url('images/logo/" + data[0]['valor'] + "')";
        img.querySelector("i").style.display = "none";

        img_antiga = data[0]['valor'];
        titulo.value = data[1]["valor"];
        rodape.value = data[2]["valor"];
        endereco.value = data[3]["valor"];
        telefone.value = data[4]["valor"];
        email.value = data[5]["valor"];
        nif.value = data[6]["valor"];
        site.value = data[7]["valor"];
      }
    });
  });
  $(document).on("click", "#btn-submit", function(e) {
    e.preventDefault();
    let form_data = new FormData();
    let img = $("#file")[0].files;
    let titulo = document.getElementById("titulo");
    let rodape = document.getElementById("rodape");
    let endereco = document.getElementById("endereco");
    let telefone = document.getElementById("telefone");
    let email = document.getElementById("email");
    let nif = document.getElementById("nif");
    let site = document.getElementById("site");

    form_data.append('file', img[0]);
    form_data.append('img_antiga', img_antiga);
    form_data.append('titulo', titulo.value);
    form_data.append('rodape', rodape.value);
    form_data.append('endereco', endereco.value);
    form_data.append('telefone', telefone.value);
    form_data.append('email', email.value);
    form_data.append('nif', nif.value);
    form_data.append('site', site.value);
    form_data.append('categoriaEmpresa', categoriaEmpresa.value);

    $.ajax({
      url: "includes/create/configuracao.inc.php",
      type: "post",
      data: form_data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(data) {
        console.log(data);
        swal.fire({
          title: "Alterações gravadas com sucesso!",
          text: "Configurações gravadas!",
          confirmButtonText: 'Confirmar',
          icon: "success",
        });
      },
      error: function(data) {
        swal.fire({
          title: "Erro ao alterar configurações!",
          text: "Erro ao configurações configurações: " + titulo.value + " !",
          confirmButtonText: 'Confirmar',
          icon: "error",
        });
      }
    });
  });
</script>