<?php include('header.php'); ?>

<body class="hold-transition layout-top-nav">
  <div class="wrapper">
    <div class="preloader flex-column justify-content-center align-items-center">
    </div>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- SELECT2 EXAMPLE -->
            <div class="col-md-12">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">Definições</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">País</small>
                        <select data-tipo="int" class="form-control formulario select2" style="width: 100%;" id="pais" name="pais">
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Série</small>
                        <select data-tipo="int" class="form-control formulario select2" style="width: 100%;" id="serie" name="serie">
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Moeda</small>
                        <select data-tipo="int" class="form-control formulario select2" style="width: 100%;" id="moeda" name="moeda">
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Qtd. Linha de preço</small>
                        <input data-tipo="int" type="number" min="1" class="form-control formulario" id="linhaPreco" name="linhaPreco" placeholder="Quantidade de Linhas de preço" title="Quantidade de Linhas de preço" required>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Linha de Preço Pré-Definida</small>
                        <select data-tipo="int" class="form-control formulario select2" style="width: 100%;" id="linhaPrecoPredefinida" name="linhaPrecoPredefinida">
                          <option value="0">Selecione Linha de Preço</option>
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Tipo de Programa</small>
                        <select data-tipo="string" class="form-control formulario select2" style="width: 100%;" id="tipoPrograma" name="tipoPrograma">
                          <option value="I">Contabilidade integrada com a facturação</option>
                          <option value="C">Contabilidade</option>
                          <option value="F">Facturação</option>
                          <option value="P">Facturação parcial</option>
                          <option value="R">Recibos</option>
                          <option value="A">Aquisição de bens e serviços</option>
                          <option value="Q">Aquisição de bens e serviços integrada com a facturação</option>
                          <option value="S">Autofacturação</option>
                          <option value="E">Facturação para o Estado</option>
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Retenção na Fonte</small>
                        <input data-tipo="float" type="text" class="form-control formulario" id="retencaoFonte" name="retencaoFonte" placeholder="Retenção na Fonte" title="Retenção na Fonte" required>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Regime Fiscal</small>
                        <select data-tipo="string" class="form-control formulario select2" style="width: 100%;" id="regimeFiscal" name="regimeFiscal">
                          <option value="Regime Geral">Regime Geral</option>
                          <option value="Regime de Exclusão">Regime de Exclusão</option>
                          <option value="Regime Transitório">Regime Transitório</option>
                          <option value="Regime Simplificado">Regime Simplificado</option>
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Imposto Deductível</small>
                        <input data-tipo="float" type="text" class="form-control formulario" id="impostoDeductivel" name="impostoDeductivel" placeholder="Imposto Deductível" title="Imposto Deductível" required>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Venda de Stock Negativo</small>
                        <select data-tipo="int" class="form-control formulario select2" style="width: 100%;" id="stockNegativo" name="stockNegativo">
                          <option value="" disabled>Selecione a opção</option>
                          <option value="0">Desabilitado</option>
                          <option value="1">Habilitado</option>
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Moeda Internacional</small>
                        <select data-tipo="int" class="form-control formulario select2" style="width: 100%;" id="moedaInternacional" name="moedaInternacional">
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small>Botão</small>
                        <button class="btn btn-block btn-primary" id="btn-submit" name="btn-submit">Gravar Alterações</button>
                      </div>
                    </div>
                    <!-- /.col -->
                  </div>
                  <!-- /.row -->
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                  Definições do sistema.
                </div>
              </div>
            </div>
          </div>
          <!-- /.card -->
        </div>
        <!-- /.container-fluid -->
      </section>
    </div>
    <!-- /.content-wrapper -->
    <?php include('footer.php'); ?>
</body>

</html>
<script>
  $(document).ready(function() {
    reload();
    funcaoSelect("../pos/includes/select.inc.php", "post", "json", "definicao", function success(data) {
      for (let i = 0; i < data.length; i++) {
        if (data[i]['descricao'] === 'pais') {
          funcaoSelect("../pos/includes/select.inc.php", "post", "json", "pais", function success(data) {
            let select = "";
            for (let j = 0; j < data.length; j++) {
              select += "<option value=" + data[j]['idPais'] + ">" + data[j]['descricao'] + "</option>";
            }
            $("#pais").html(select);
          }, function error(data) {

          }, function done(data) {
            funcaoSelect("../pos/includes/select.inc.php", "post", "json", "definicao", function success(data) {
              for (let j = 0; j < data.length; j++) {
                if (data[j]['descricao'] === 'pais') {
                  $('#pais').val(data[j]['valor']);
                  $('#pais').select2().trigger('change');
                }
              }
            }, function error(data) {

            }, function done(data) {

            });
          });
        }

        if (data[i]['descricao'] === 'serie') {
          funcaoSelect("../pos/includes/select.inc.php", "post", "json", "serie", function success(data) {
            let select = "";
            for (let j = 0; j < data.length; j++) {
              select += "<option value=" + data[j]['idSerie'] + ">" + data[j]['descricao'] + "</option>";
            }
            $("#serie").html(select);
          }, function error(data) {

          }, function done(data) {
            funcaoSelect("../pos/includes/select.inc.php", "post", "json", "definicao", function success(data) {
              for (let j = 0; j < data.length; j++) {
                if (data[j]['descricao'] === 'serie') {
                  //$('#serie').val(data[j]['valor']);
                  //$('#serie').select2().trigger('change');
                }
              }
            }, function error(data) {

            }, function done(data) {

            });
          });
        }

        if (data[i]['descricao'] === 'moeda') {
          funcaoSelect("../pos/includes/select.inc.php", "post", "json", "moeda", function success(data) {
            let select = "";
            for (let j = 0; j < data.length; j++) {
              select += "<option value=" + data[j]['idMoeda'] + ">" + data[j]['nome'] + "</option>";
            }
            $("#moeda").html(select);
          }, function error(data) {

          }, function done(data) {
            funcaoSelect("../pos/includes/select.inc.php", "post", "json", "definicao", function success(data) {
              for (let j = 0; j < data.length; j++) {
                if (data[j]['descricao'] === 'moeda') {
                  $('#moeda').val(data[j]['valor']);
                  $('#moeda').select2().trigger('change');
                }
              }
            }, function error(data) {

            }, function done(data) {

            });
          });
        }

        if (data[i]['descricao'] === 'StockNegativo') {
          $('#stockNegativo').val(data[i]['valor']);
          $('#stockNegativo').select2().trigger('change');
        }

        if (data[i]['descricao'] === 'moedaInternacional') {
          funcaoSelect("../pos/includes/select.inc.php", "post", "json", "moeda", function success(data) {
            let select = "";
            for (let j = 0; j < data.length; j++) {
              select += "<option value=" + data[j]['idMoeda'] + ">" + data[j]['nome'] + "</option>";
            }
            $("#moedaInternacional").html(select);
          }, function error(data) {

          }, function done(data) {
            funcaoSelect("../pos/includes/select.inc.php", "post", "json", "definicao", function success(data) {
              for (let j = 0; j < data.length; j++) {
                if (data[j]['descricao'] === 'moedaInternacional') {
                  $('#moedaInternacional').val(data[j]['valor']);
                  $('#moedaInternacional').select2().trigger('change');
                }
              }
            }, function error(data) {

            }, function done(data) {

            });
          });
        }
      }
    }, function error(data) {

    }, function done(data) {});
  });

  function reload() {
    $.ajax({
      url: "includes/read/definicao.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        let select = "";
        console.log(data);
        for (var key in data) {
          if (data[key]["idDefinicao"] == 1) {
            linhaPreco.value = data[key]["valor"];
            for (let i = 0; i < data[key]["valor"]; i++) {
              select += `<option value="${i + 1}">P.Venda (${i + 1})</option>`;
            }
          }

          if (data[key]["idDefinicao"] == 5) {
            $('#moeda').val(data[key]['valor']);
            $('#moeda').select2().trigger('change');
          }

          if (data[key]["idDefinicao"] == 3) {
            $('#serie').val(data[key]['valor']);
            $('#serie').select2().trigger('change');
          }

          if (data[key]["idDefinicao"] == 4) {
            $('#pais').val(data[key]['valor']);
            $('#pais').select2().trigger('change');
          }

          if (data[key]["idDefinicao"] == 6) {
            $('#tipoPrograma').val(data[key]['valor']);
            $('#tipoPrograma').select2().trigger('change');
          }

          if (data[key]["idDefinicao"] == 7) {
            retencaoFonte.value = parseFloat(data[key]['valor']).toFixed(2).replace(/\ /g, '').replace(/\./g, ',');
          }

          if (data[key]["idDefinicao"] == 8) {
            $('#regimeFiscal').val(data[key]['valor']);
            $('#regimeFiscal').select2().trigger('change');
          }


          if (data[key]["idDefinicao"] == 9) {
            impostoDeductivel.value = parseFloat(data[key]['valor']).toFixed(2).replace(/\ /g, '').replace(/\./g, ',');
          }
        }
        $("#linhaPrecoPredefinida").html(select);
      }
    }).done(function(data) {
      for (var key in data) {
        if (data[key]["idDefinicao"] == 2) {
          $('#linhaPrecoPredefinida').val(data[key]['valor']);
          $('#linhaPrecoPredefinida').select2().trigger('change');
        }
      }
    });
  }
  $(document).on("click", "#btn-submit", function(e) {
    e.preventDefault();
    funcaoSelect("../pos/includes/select.inc.php", "post", "json", "definicao", function success(data) {
      for (let j = 0; j < data.length; j++) {
        const formulario = document.querySelectorAll('.formulario');
        for (let i = 0; i < formulario.length; i++) {
          if (data[j]['descricao'] === formulario[i].id) {
            console.log("Pegar definicao: ", data[j]['descricao']);
            funcaoUpdate("../pos/includes/update.inc.php", "post", "json", "definicao", {
              "valor": formulario[i].dataset.tipo === 'string' ? formulario[i].value : formulario[i].dataset.tipo === 'int' ? parseInt(formulario[i].value.replace(/\ /g, '').replace(/\,/g, '.')) : parseFloat(formulario[i].value.replace(/\ /g, '').replace(/\,/g, '.'))
            }, {
              idDefinicao: data[j]['idDefinicao']
            }, function success(data) {
              reload();
              console.log(data);
              swal.fire({
                title: "Alterações gravadas com sucesso!",
                text: "Definições gravadas!",
                confirmButtonText: 'Confirmar',
                confirmButtonColor: '#560085',
                icon: "success",
              });
            }, function error(data) {
              console.log("yh: ", data);
              reload();
              swal.fire({
                title: "Erro ao alterar definições!",
                text: "Erro ao alterar definições.",
                confirmButtonText: 'Confirmar',
                confirmButtonColor: '#560085',
                icon: "error",
              });
            }, function done(data) {

            })
          }
        }
      }
    }, function error(data) {

    }, function done(data) {

    });
    /*let dados = {};
    dados[formulario[i].id] = formulario[i].value;
    funcaoUpdate("../pos/includes/update.inc.php", "post", "json", "definicao", {"valor" : formulario[i].value}, {
      idDefinicao: i + 1
    }, function success(data) {
      reload();
      console.log(data);
      swal.fire({
        title: "Alterações gravadas com sucesso!",
        text: "Definições gravadas!",
        confirmButtonText: 'Confirmar',
        confirmButtonColor: '#560085',
        icon: "success",
      });
    }, function error(data) {
      console.log("yh: ", data);
      reload();
      swal.fire({
        title: "Erro ao alterar definições!",
        text: "Erro ao alterar definições.",
        confirmButtonText: 'Confirmar',
        confirmButtonColor: '#560085',
        icon: "error",
      });
    }, function done(data) {

    });*/
  });
</script>
<script src="./validation/definicao.js"></script>