<?php
    class PrazoPagamentoModel extends Database {

		protected function insertPrazoPagamento($nome, $nota){
            $stmt = $this->connect();
            $sql = "INSERT INTO prazoPagamento (nome, nota) VALUES (?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($nome, $nota)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemPrazoPagamento(){
			$data = null;
			$sql = "SELECT * FROM prazoPagamento";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryPrazoPagamento($idPrazoPagamento){
			$data = null;
			$sql = "SELECT * FROM prazoPagamento WHERE idPrazoPagamento = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idPrazoPagamento]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editPrazoPagamento($idPrazoPagamento, $nome, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE prazoPagamento SET nome = ?, nota = ? WHERE idPrazoPagamento = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $nota, $idPrazoPagamento)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deletePrazoPagamento($idPrazoPagamento){
			$stmt = $this->connect();
            $sql = "DELETE FROM prazoPagamento WHERE idPrazoPagamento = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idPrazoPagamento)))){
				$query = null;
				exit();
			}
		}
    }