<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" integrity="sha384-3fdgwJw17Bi87e1QQ4fsLn4rUFqWw//KU0g8TvV6quvahISRewev6/EocKNuJmEw" crossorigin="anonymous">
</head>

<body>

    <div class="container">
        <div class="row">
            <div class="col text-center" style="margin-top: 25px; margin-bottom: 25px;">
                <select id="selectDepartamento" class="custom-select">
                    <option value="Departamento TI" selected>Departamento TI</option>
                    <option value="Departamento RH">Departamento RH</option>
                    <option value="Departamento Contabilistico">Departamento Contabilistico</option>
                </select>
            </div>
        </div>
        <div class="row">
            <div class="col" id="divGrafico"></div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        $(document).ready(function() {
            $.ajax({
                url: "./includes/read/chart.inc.php",
                dataType: "json",
                type: "post",
                data: {
                    departamento: "Departamento TI"
                },
                success: function(data) {
                    let pessoas = "";
                    let mes = "";
                    for (let i = 0; i < data.length; i++) {
                        pessoas += `${data[i]['pessoas']}`;
                        mes += `"${data[i]['mes']}"`;
                        if (i < data.length - 1) {
                            pessoas += ",";
                            mes += ",";
                        }
                    }

                    let config = {
                        type: "bar",
                        data: {
                            labels: JSON.parse(`[${mes}]`),
                            datasets: [{
                                label: "Departamento TI Pessoas",
                                backgroundColor: "#000000",
                                borderColor: "#000000",
                                data: JSON.parse(`[${pessoas}]`)
                            }]
                        },
                        options: {
                            legend: {
                                display: true
                            }
                        }
                    };

                    let grafico = `<canvas id="grafico"></canvas>`;
                    $("#divGrafico").html(grafico);

                    // Obtendo o contexto do canvas
                    var ctx = document.getElementById('grafico').getContext('2d');

                    // Criando a instância do Chart
                    new Chart(ctx, config);

                    console.log("Pessoas: ", pessoas);
                    console.log("Mes: ", mes);
                }
            });
        });

        $("#selectDepartamento").change(function() {
            let parametro = $(this).val();
            $.ajax({
                url: "./includes/read/chart.inc.php",
                dataType: "json",
                type: "post",
                data: {
                    departamento: parametro
                },
                success: function(data) {
                    let pessoas = "";
                    let mes = "";
                    for (let i = 0; i < data.length; i++) {
                        pessoas += `${data[i]['pessoas']}`;
                        mes += `"${data[i]['mes']}"`;
                        if (i < data.length - 1) {
                            pessoas += ",";
                            mes += ",";
                        }
                    }

                    let config = {
                        type: "bar",
                        data: {
                            labels: JSON.parse(`[${mes}]`),
                            datasets: [{
                                label: '"' + `${parametro} Pessoas` + '"',
                                backgroundColor: "#000000",
                                borderColor: "#000000",
                                data: JSON.parse(`[${pessoas}]`)
                            }]
                        },
                        options: {
                            legend: {
                                display: true
                            }
                        }
                    };

                    let grafico = `<canvas id="grafico"></canvas>`;
                    $("#divGrafico").html(grafico);

                    // Obtendo o contexto do canvas
                    var ctx = document.getElementById('grafico').getContext('2d');

                    // Criando a instância do Chart
                    new Chart(ctx, config);
                }
            });
        });
    </script>
</body>

</html>