<?php
class UsuarioModel extends Database
{

	protected function insertUsuario($idTipoUsuario, $idTerminal, $nome, $genero, $bi, $email, $nomeUsuario, $estado)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO usuario (idTipoUsuario, idTerminal, nome, genero, bi, email, nomeUsuario, estado) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($idTipoUsuario, $idTerminal, $nome, $genero, $bi, $email, $nomeUsuario, $estado)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function insertPeriodoCurso($idUsuario, $periodo, $curso)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO periodoCursoAluno (aluno, periodo, curso) VALUES (?, ?, ?)";
		$query = $stmt->prepare($sql);
		$query->execute(array($idUsuario, $periodo, $curso));
	}

	protected function insertTurmaAluno($idTurma, $idAluno)
	{
		$stmt = $this->connect();

		$sql = "INSERT INTO turmaaluno (turma, aluno) VALUES (?, ?)";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($idTurma, $idAluno)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function tipoUsuario($idTipoUsuario)
	{
	}

	public function readTurma()
	{
		$data = null;
		$sql = "SELECT * FROM turma";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function editTurma($idTurma, $capacidade)
	{
		$stmt = $this->connect();

		$sql = "UPDATE turma SET capacidade = ? WHERE idTurma = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($capacidade, $idTurma)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function readTipoUsuario($idUsuario)
	{
		$data = null;
		$sql = "SELECT * FROM usuario WHERE idUsuario = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function fotoPerfil($idUsuario)
	{
		$data = null;
		$sql = "SELECT * FROM usuario WHERE idUsuario = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function deleteUsuario($idUsuario)
	{
		$img = $this->fotoPerfil($idUsuario);
		$nameImg = "../../images/usuario/" . $img[0]["imagem"];
		if ($img[0]["imagem"] != null) {
			unlink($nameImg);
		}
		$stmt = $this->connect();
		$sql = "DELETE FROM usuario WHERE idUsuario = ?";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idUsuario)))) {
			$query = null;
			exit();
		}
	}

	protected function editUsuario($idUsuario, $idTipoUsuario, $idTerminal, $nome, $genero, $bi, $email, $nomeUsuario, $estado)
	{
		$stmt = $this->connect();

		$sql = "UPDATE usuario SET idTipoUsuario = ?, idTerminal = ? nome = ?, genero = ?, bi = ?, email = ?, nomeUsuario = ?, estado = ? WHERE idUsuario = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($idTipoUsuario, $idTerminal, $nome, $genero, $bi, $email, $nomeUsuario, $estado, $idUsuario)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	public function listagemAluno()
	{
		$data = null;
		$sql = "SELECT * FROM viewusuariotipoidentificador WHERE idTipoUsuario = 2";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemProfessor()
	{
		$data = null;
		$sql = "SELECT * FROM viewusuariotipo WHERE idTipoUsuario = 3";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemUsuario()
	{
		$data = null;
		$sql = "SELECT * FROM viewusuariotipo";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function searchUsuario($idUsuario)
	{
		$data = null;
		$sql = "SELECT * FROM viewUsuarioTipo WHERE idUsuario = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function querydataNasc($dataNasc)
	{
		$data = null;
		$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE dataNasc = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$dataNasc]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryEmail($email)
	{
		$data = null;
		$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE email = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$email]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryNomeUsuario($nomeUsuario)
	{
		$data = null;
		$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE nomeUsuario = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$nomeUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryPassword($idUsuario)
	{
		$data = null;
		$sql = "SELECT * FROM usuario WHERE idUsuario = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listaUsuario()
	{
		$data = null;
		$sql = "SELECT * FROM usuario";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function autoIncrementUsuario()
	{
		$sql = "SELECT `AUTO_INCREMENT` AS contador
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'usuario';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['contador'];
	}

	public function queryAluno($turma)
	{
		$data = null;
		if ($turma == 0) {
			$sql = "SELECT * FROM turmaaluno ta INNER JOIN viewusuariotipo u ON (ta.aluno=u.idUsuario)";
			if ($stmt = $this->connect()->query($sql)) {
				while ($row = $stmt->fetch()) {
					$data[] = $row;
				}
			}
		} else {
			$sql = "SELECT * FROM turmaaluno ta INNER JOIN viewusuariotipo u ON (ta.aluno=u.idUsuario) WHERE ta.turma = ?";
			if ($stmt = $this->connect()->prepare($sql)) {
				$stmt->execute([$turma]);
				while ($row = $stmt->fetch()) {
					$data[] = $row;
				}
			}
		}
		return $data;
	}

	public function dataAluno($idAluno)
	{
		$data = null;
		$sql = "SELECT * FROM viewdataaluno WHERE idTipoUsuario = 2 AND idUsuario = ? ORDER BY idUsuario ASC";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idAluno]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function dataUsuario($idUsuario)
	{
		$data = null;
		$sql = "SELECT * FROM viewdatausuario WHERE NOT idTipoUsuario BETWEEN 2 AND 3 AND idUsuario = ? ORDER BY idUsuario ASC";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function codigoUsuario($idUsuario)
	{
		$data = null;
		$sql = "SELECT * FROM viewidentificadoruser WHERE idUsuario = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryUsuario($idUsuario)
	{
		$data = null;
		$sql = "SELECT * FROM viewusuariotipo WHERE idUsuario = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryUsuarioTipo($idTipoUsuario)
	{
		$data = null;
		$sql = "SELECT * FROM viewusuariotipo WHERE idTipoUsuario = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTipoUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryUser($idUsuario, $senha)
	{
		$data = null;
		$sql = "SELECT * FROM usuario WHERE idUsuario = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		$pwdHashed = $data[0]["senha"];
		$checkPwd = password_verify($senha, $pwdHashed);
		return $checkPwd;
	}

	private function readUsuario($nomeUsuarioEmail){
		$data = null;
		$sql = "SELECT * FROM usuario WHERE nomeUsuario = ? OR email = ?";
		if($stmt = $this->connect()->prepare($sql)){
			$stmt->execute([$nomeUsuarioEmail, $nomeUsuarioEmail]);
			while($row = $stmt->fetch()){
			 $data[] = $row;
			}
		}
		return $data;
	}

	public function updateSenha($idUsuario, $senha){
		$usuario = $this->readUsuario($idUsuario);
		$id = $usuario[0]["idUsuario"];
		$stmt = $this->connect();
		$sql = "UPDATE usuario SET senha = ? WHERE idUsuario = ?";
		$query = $stmt->prepare($sql);
		
		$hashedSenha = password_hash($senha, PASSWORD_DEFAULT);
		if(!($query->execute(array($hashedSenha, $id)))){
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $senha;
	}

	public function updateSenhaUser($idUsuario, $senha){
		$stmt = $this->connect();
		$sql = "UPDATE usuario SET senha = ? WHERE idUsuario = ?";
		$query = $stmt->prepare($sql);
		
		$hashedSenha = password_hash($senha, PASSWORD_DEFAULT);
		if(!($query->execute(array($hashedSenha, $idUsuario)))){
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $senha;
	}
}
