<?php

class StockModel extends Database {

		protected function insertStock($idUsuario, $idCarro, $qtd){
			$sql = "INSERT INTO stock (idUsuario, idCarro, qtd) VALUES (?, ?, ?)";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idUsuario, $idCarro, $qtd))){
				$stmt = null;
				header("location: ../forms/stockForm.php?Erro=Inserir!");
				exit();
			}
			$stmt = null;
		}

		public function deleteStock($idStock){
			$sql = "DELETE FROM stock WHERE idSock = ?";
			$stmt = $this->connect()->prepare($sql);
			$stmt->execute([$idStock]);
		}

		protected function readStock(){
			$sql = "SELECT * FROM stock";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){
				$row['idStock'];
				$row['idUsuario'];
				$row['idCarro'];
				$row['qtdDisp'];
				$row['qtd'];
				$row['estado'];
			}
		}

		protected function updateStock($idCarro, $qtd, $idStock){
			$sql = "UPDATE stock SET idCarro = ?, qtd = ? WHERE idStock = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idCarro, $qtd, $idStock))){
				$stmt = null;
				header("location: ../forms/stockForm.php?Erro=Editar!");
				exit();
			}
			$stmt = null;
		}

		/*protected function deleteStock($idSotck){
			$sql = "DELETE FROM stock WHERE idSotck = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!stmt->execute(array($idSotck))){
				$stmt = null;
				header("location: ../forms/stockForm.php?Erro=Eliminar!");
				exit();
			}
			$stmt = null;
		}*/

		protected function listaStock(){
			$sql = "SELECT * FROM viewStockCarro";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){
				$estado;
				if($row['carroEstado'] == 0){
					$estado = "Inactivo";
				} else {
					$estado = "Activo";
				}
				echo '<tr>
					<td>'.$row['idStock'].'</td>
					<td>'.$row['qtdDisp'].'</td>
					<td>'.$row['qtd'].'</td>
					<td>'.$row['estado'].'</td>
					<td>'.$row['idCarro'].'</td>
					<td>'.$row['nomeCarro'].'</td>
					<td>'.$estado.'</td>
					<td>
						<a href="../includes/stockUpdate.inc.php?'.$row['idStock'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../admin/includes/stockDelete.inc.php?'.$row['idStock'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}
	}