<?php
    class MatriculaModel extends Database {

		protected function insertMatricula($nProcesso, $matricula, $nQuadro, $classeVeiculo, $servico, $codigoPlacaDianteira, $codigoPlacaTraseira){
            $stmt = $this->connect();
            $sql = "INSERT INTO dbLocal (nProcesso, matricula, nQuadro, classeVeiculo, servico, codigoPlacaDianteira, codigoPlacaTraseira) VALUES (?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($nProcesso, $matricula, $nQuadro, $classeVeiculo, $servico, $codigoPlacaDianteira, $codigoPlacaTraseira)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemMatricula(){
			$data = null;
			$sql = "SELECT * FROM dbLocal";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryMatricula($matricula){
			$data = null;
			$sql = "SELECT * FROM factura WHERE matricula = ? AND estado = 0";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$matricula]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryMatriculaExist($matricula){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE fMatricula = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$matricula]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryPlate($matricula){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE idDescricao = ?;";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$matricula]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}
    }