<?php
class DocumentoModel extends Database
{

	protected function insertDocumento($idUsuario, $idTipoDoc, $idEntidade, $idPrazoPagamento, $entregue, $total, $troco, $totalLiquido, $totalImposto, $descontoGlobal)
	{
		try {
			$stmt = $this->connect();
			$serie = $this->definicao(3);
			if ($idTipoDoc != 33) {
				$hash = $this->hashLastInsertedId($idTipoDoc);
			}
			$sql = "INSERT INTO documento (idUsuario, idTipoDoc, idEntidade, idPrazoPagamento, idSerie, entregue, total, troco, totalLiquido, imposto, descontoGlobal) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			$query = $stmt->prepare($sql);
			if (!($query->execute(array($idUsuario, $idTipoDoc, $idEntidade, $idPrazoPagamento, $serie[0]["valor"], $entregue, $total, $troco, $totalLiquido, $totalImposto, $descontoGlobal)))) {
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			if ($idTipoDoc != 33) {
				$this->adicionarHash($id, $hash);
			}
			return $id;
		} catch (Exception $e) {
			return "Almeida catch";
		}
	}

	private function adicionarHash($id, $hash){
		$documento = $this->queryDocumento($id);
		if (file_exists("../../saft/ChavePrivada.pem") && is_array($documento)) {
			if($hash["contador"] <= 0){
				$content = date("Y-m-d", strtotime($documento[0]["dataDoc"])) . ";" . date("Y-m-d", strtotime($documento[0]["dataDoc"])) . "T" . date("H:i:s", strtotime($documento[0]["dataDoc"])) . ";" . $documento[0]["codigoDocumento"]. ";" . $documento[0]["total"] . ";";
			} else if($hash["contador"] > 0){
				$content = date("Y-m-d", strtotime($documento[0]["dataDoc"])) . ";"
				 . date("Y-m-d", strtotime($documento[0]["dataDoc"])) . "T" . date("H:i:s", strtotime($documento[0]["dataDoc"])) . ";" . $documento[0]["codigoDocumento"]. ";" . $documento[0]["total"] . ";" . $hash["dados"][0]["hashSaft"];
			}
			$assinatura = "";
			$key = file_get_contents("../../saft/ChavePrivada.pem");
			openssl_sign($content, $assinatura, $key, OPENSSL_ALGO_SHA1);
			$sha1 = bin2hex($assinatura);
			$base64 = base64_encode($assinatura);

			$stmt = $this->connect();
			$sql = "UPDATE documento SET hashSaft = ? WHERE idDocumento = ?";
			$query = $stmt->prepare($sql);
			if (!($query->execute(array($base64, $id)))) {
				$query = null;
				exit();
			}
			
		}
	}

	private function hashLastInsertedId($id)
	{
		$data = null;
		$sql = "SELECT * FROM documento WHERE idTipoDoc = ? ORDER BY idDocumento DESC LIMIT 1";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$id]);
			$rowCount = $stmt->rowCount();
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return ["contador" => $rowCount, "dados" => $data];
	}

	private function definicao($id)
	{
		$data = null;
		$sql = "SELECT * FROM definicao WHERE idDefinicao = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$id]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function insertDocumentoStock($idUsuario, $idTipoDoc, $idEntidade, $idPrazoPagamento, $entregue, $total, $troco, $totalLiquido, $totalImposto, $totalDesconto)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO documento (idUsuario, idTipoDoc, total) VALUES (?, ?, ?)";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idUsuario, $idTipoDoc, $total)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function verificarAdiantamento($idEntidade)
	{
		$data = null;
		$sql = "SELECT idDocumento, entregue FROM documento WHERE idEntidade = ? AND idTipoDoc = 33 LIMIT 1";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idEntidade]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		if ($data[0] == null) {
			return null;
		} else {
			return $data;
		}
		
	}

	protected function updateAdiantado($idDocumento, $entregue)
	{
		$stmt = $this->connect();
			$sql = "UPDATE documento SET entregue = ? WHERE idDocumento = ?";
			$query = $stmt->prepare($sql);
			if (!($query->execute(array($entregue, $idDocumento)))) {
				$query = null;
				exit();
			}
	}

	public function listagemDocumento()
	{
		$data = null;
		$sql = "SELECT * FROM viewartigomodopagamentodocumento";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryDoc($idDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM viewartigotipodocumento WHERE idDocumento = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryTipoDocumentoSerie($idTipoDocumento, $idSerie)
	{
		$data = null;
		$sql = "SELECT * FROM viewartigomodopagamentodocumento WHERE idTipoDoc = ? AND idSerie = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTipoDocumento, $idSerie]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function insertCaixaBanco($idUsuario, $idcaixa, $valorabertura, $datat){
		try {
			$stmt = $this->connect();
			
			$sql = "INSERT INTO movimento_caixa (idUsuario, idcaixa, valorabertura, data_time_abertura) VALUES (?, ?, ?, ?)";
			$query = $stmt->prepare($sql);
			if (!($query->execute(array($idUsuario, $idcaixa, $valorabertura, $datat)))) {
				$query = null;
				//exit();
			}else{

			return 'Erro';
			}
				return $query;
			//$id = $stmt->lastInsertId();
			return 1;
		} catch (Exception $e) {
			return "Almeida catch";
		}
	}

	public function queryDocumento($idDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM viewartigomodopagamentodocumento WHERE idDocumento = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function CaixaBanco($idUsuario)
	{
		$data = null;
		$sql = "SELECT mc.*, caixabanco.descricao as descricao FROM movimento_caixa as mc INNER JOIN caixabanco ON mc.caixa_id = caixabanco.idCaixabanco WHERE usuario_id = ? AND data_time_fecho IS Null";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		if ($data) {
			return $data;
		} else {
			return 0;
		}
		
		
	}



	public function queryDocumentoStock($idDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM viewStock WHERE idDocumento = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryDocumentoEntidade($idEntidade, $idTipoDoc)
	{
		$data = null;
		$sql = "SELECT * FROM viewartigomodopagamentodocumento WHERE idEntidade = ? AND idTipoDoc = ? AND entregue < total";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idEntidade, $idTipoDoc]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryModoPagamentoDocumento($idDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM viewModoPagamentoDocumento WHERE idDocumento = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryMotivoIsencao($idDocumento)
	{
		$data = null;
		$sql = "SELECT motivoisencao.motivo FROM imposto INNER JOIN motivoisencao ON imposto.idMotivoIsencao = motivoisencao.idMotivoIsencao WHERE idImposto = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	

// 	public function queryDocumentoTipo($idTipoDocumento)
// 	{
// 		$data = null;
// 		$sql = "SELECT * FROM viewartigomodopagamentodocumento WHERE idTipoDoc = ? ORDER BY descricaoId";
// 		if ($stmt = $this->connect()->prepare($sql)) {
// 			$stmt->execute([$idTipoDocumento]);
// 			while ($row = $stmt->fetch()) {
// 				$data[] = $row;
// 			}
// 		}
// 		return $data;
// 	}

 public function queryDocumentoTipo($idTipoDocumento)
    {
        $resultado = [
            "success" => false,
            "data"    => [],
            "error"   => null
        ];
    
        try {
            // Força o ID a ser numérico (evita caracteres especiais e SQL injection)
            $idTipoDocumento = (int) $idTipoDocumento;
    
            $sql = "SELECT * 
                      FROM viewartigomodopagamentodocumento 
                     WHERE idTipoDoc = ? 
                  ORDER BY descricaoId";
    
            $stmt = $this->connect()->prepare($sql);
            $stmt->execute([$idTipoDocumento]);
    
            while ($row = $stmt->fetch(\PDO::FETCH_ASSOC)) {
                // Garante que todos os valores sejam convertidos para UTF-8
                $rowUtf8 = array_map(function ($valor) {
                    return is_string($valor) 
                        ? mb_convert_encoding($valor, 'UTF-8', 'auto') 
                        : $valor;
                }, $row);
    
                $resultado["data"][] = $rowUtf8;
            }
    
            $resultado["success"] = true;
        } catch (\PDOException $e) {
            $resultado["error"] = "Erro no banco de dados: " . $e->getMessage();
        } catch (\Exception $e) {
            $resultado["error"] = "Erro inesperado: " . $e->getMessage();
        }
    
        return $resultado['data'] ?? [];
    }

	public function queryDocumentoTipoStock($idTipoDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM viewStock WHERE idTipoDoc = ? ORDER BY descricaoId";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTipoDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryDocumentoLinha($idDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM viewdocumento vd INNER JOIN imposto i on (vd.idImpostoAd = i.idImposto) WHERE idDocumento = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryDocumentoLinhaNota($idDocumento)
	{
		$data = null;
		$sql = "SELECT DISTINCT vd.*, i.*, docrelac.idDocRelac, vwd.codigoDocumento as codigodocrelac FROM viewdocumento vd INNER JOIN imposto i on (vd.idImpostoAd = i.idImposto) INNER JOIN docrelac ON vd.idDocumento = docrelac.idDocumento INNER JOIN viewdocumento as vwd ON docrelac.idDocRelac = vwd.idDocumento WHERE vd.idDocumento = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryStock($idDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM documento d INNER JOIN artigoDocumento ad ON (d.idDocumento = ad.idDocumento) INNER JOIN artigoStock astk ON (ad.idArtigo = astk.idArtigo) WHERE d.idDocumento = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryStockSaida($idDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM documento d INNER JOIN artigoDocumento ad ON (d.idDocumento = ad.idDocumento) INNER JOIN artigoStock astk ON (ad.idArtigo = astk.idArtigo) WHERE d.idDocumento = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryStockInventario($idDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM documento d INNER JOIN itemStockInventario its ON (d.idDocumento = its.idDocumento) WHERE d.idDocumento = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryDocumentoFac($codigo, $idTipoDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM viewartigomodopagamentodocumento vd INNER JOIN docrelac dr ON (vd.idDocumento = dr.idDocRelac) WHERE dr.idDocumento = ? AND idTipoDoc = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$codigo, $idTipoDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryTipoTaxa($idTipoTaxa)
	{
		$data = null;
		$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTipoTaxa]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listaTipoTaxa()
	{
		$data = null;
		$sql = "SELECT * FROM tipotaxa";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function insertDocumentoRelacao($idDocumento, $idDocumentoRelac, $faltaDocRelac, $idUsuario, $idTipoDoc, $idEntidade, $idPrazoPagamento, $entregue, $total, $troco, $totalLiquido, $totalImposto, $descontoGlobal)
	{
		$stmt = $this->connect();

		$sql = "INSERT docrelac SET idDocumento = ?, idDocRelac = ?, entregueDocRelac = ?, faltaDocRelac = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($idDocumento, $idDocumentoRelac, $entregue, $faltaDocRelac)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	public function updateEstadoDocumento($idDocumento, $estado)
	{
		$data = null;
		$stmt = $this->connect();

		$sql = "UPDATE documento SET estadoEmissao = ? WHERE idDocumento = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($estado, $idDocumento)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		$result = $this->queryArtigoDocumento($idDocumento);
		for($i = 0; $i < count($result); $i++){
			$this->updateArtigoStock($result[$i]["idArtigo"], $result[$i]["qtd"]);
		}
		return $result;
	}

	private function queryArtigoDocumento($idDocumento){
		$data = null;
		$sql = "SELECT * FROM artigoDocumento WHERE idDocumento = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function updateArtigoStock($idArtigo, $qtdStock)
	{
		$stmt = $this->connect();

		$sql = "UPDATE artigoStock SET qtdDisponivel = qtdDisponivel - ? WHERE idArtigo = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($qtdStock, $idArtigo)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editDocumentoFactura($idDocumento, $idUsuario, $idTipoDoc, $idEntidade, $idPrazoPagamento, $entregue, $total, $troco, $totalLiquido, $totalImposto, $descontoGlobal)
	{
		$stmt = $this->connect();

		$sql = "UPDATE documento SET entregue = entregue + ? WHERE idDocumento = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($entregue, $idDocumento)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editDocumento($idDocumento, $idUsuario, $idTipoDoc, $idEntidade, $idPrazoPagamento, $entregue, $total, $troco, $totalLiquido, $totalImposto, $descontoGlobal)
	{
		$stmt = $this->connect();

		$sql = "UPDATE documento SET idUsuario = ?, idTipoDoc = ?, idEntidade = ?, idPrazoPagamento = ?, entregue = ?, total = ?, troco = ?, totalLiquido = ?, imposto = ?, descontoGlobal = ? WHERE idDocumento = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($idUsuario, $idTipoDoc, $idEntidade, $idPrazoPagamento, $entregue, $total, $troco, $totalLiquido, $totalImposto, $descontoGlobal, $idDocumento)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	public function deleteDocumento($idDocumento)
	{
		$stmt = $this->connect();
		$sql = "DELETE FROM documento WHERE idDocumento = ?";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idDocumento)))) {
			$query = null;
			exit();
		}
	}

	public function readRealCodeDocumento($codigo, $tipoDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM viewartigomodopagamentodocumento WHERE descricaoId = ? AND idTipoDoc = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$codigo, $tipoDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function readRealCodeDocumentoStock($codigo, $tipoDocumento)
	{
		$data = null;
		$sql = "SELECT * FROM viewStock WHERE descricaoId = ? AND idTipoDoc = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$codigo, $tipoDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function readCodigoDocumento($codigo)
	{
		$data = null;
		$sql = "SELECT COALESCE(MAX(descricaoId), 0) + 1 AS contador FROM viewartigomodopagamentodocumento WHERE  idTipoDoc = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$codigo]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function readCodigoDoc()
	{
		$data = null;
		$sql = "SELECT COALESCE(MAX(idDocumento), 0) AS contador FROM documento";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function verifyDocumento($idTipoDocumento, $idDocumento)
	{
		$data = null;
		$sql = "SELECT COUNT(*) AS contador FROM viewartigomodopagamentodocumento WHERE idTipoDoc = ? AND descricaoId = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTipoDocumento, $idDocumento]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function totalVenda()
	{
		$data = null;
		$sql = "SELECT SUM(total) AS 'contador' FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (1, 2)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemTotalVenda()
	{
		$data = null;
		$sql = "SELECT * FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (1, 2)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function chartVenda()
	{
		$data = null;
		$sql = "SELECT SUM(total) as total, CASE 
			WHEN MONTH(dataDoc) = '1' THEN 'Janeiro'
			WHEN MONTH(dataDoc) = '2' THEN 'Fevereiro'
			WHEN MONTH(dataDoc) = '3' THEN 'Março'
			WHEN MONTH(dataDoc) = '4' THEN 'Abril'
			WHEN MONTH(dataDoc) = '5' THEN 'Maio'
			WHEN MONTH(dataDoc) = '6' THEN 'Junho'
			WHEN MONTH(dataDoc) = '7' THEN 'Julho'
			WHEN MONTH(dataDoc) = '8' THEN 'Agosto'
			WHEN MONTH(dataDoc) = '9' THEN 'Setembro'
			WHEN MONTH(dataDoc) = '10' THEN 'Outubro'
			WHEN MONTH(dataDoc) = '11' THEN 'Novembro'
			WHEN MONTH(dataDoc) = '12' THEN 'Dezembro'
		  END AS mes FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (1, 2)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		$result = $this->chartRecebimento();
		return [$data, $result];
	}

	public function chartRecebimento()
	{
		$data = null;
		$sql = "SELECT SUM(total) as total, CASE 
			WHEN MONTH(dataDoc) = '1' THEN 'Janeiro'
			WHEN MONTH(dataDoc) = '2' THEN 'Fevereiro'
			WHEN MONTH(dataDoc) = '3' THEN 'Março'
			WHEN MONTH(dataDoc) = '4' THEN 'Abril'
			WHEN MONTH(dataDoc) = '5' THEN 'Maio'
			WHEN MONTH(dataDoc) = '6' THEN 'Junho'
			WHEN MONTH(dataDoc) = '7' THEN 'Julho'
			WHEN MONTH(dataDoc) = '8' THEN 'Agosto'
			WHEN MONTH(dataDoc) = '9' THEN 'Setembro'
			WHEN MONTH(dataDoc) = '10' THEN 'Outubro'
			WHEN MONTH(dataDoc) = '11' THEN 'Novembro'
			WHEN MONTH(dataDoc) = '12' THEN 'Dezembro'
		  END AS mes FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (2, 3)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function totalRecebimento()
	{
		$data = null;
		$sql = "SELECT SUM(total) AS 'contador' FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (2, 3)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemTotalRecebimento()
	{
		$data = null;
		$sql = "SELECT * FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (2, 3)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function totalCompra()
	{
		$data = null;
		$sql = "SELECT SUM(total) AS 'contador' FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (23, 24)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemTotalCompra()
	{
		$data = null;
		$sql = "SELECT * FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (23, 24)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function totalPagamento()
	{
		$data = null;
		$sql = "SELECT SUM(total) AS 'contador' FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (24, 30)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemTotalPagamento()
	{
		$data = null;
		$sql = "SELECT * FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (24, 30)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function chartCompra()
	{
		$data = null;
		$sql = "SELECT SUM(total) as total, CASE 
			WHEN MONTH(dataDoc) = '1' THEN 'Janeiro'
			WHEN MONTH(dataDoc) = '2' THEN 'Fevereiro'
			WHEN MONTH(dataDoc) = '3' THEN 'Março'
			WHEN MONTH(dataDoc) = '4' THEN 'Abril'
			WHEN MONTH(dataDoc) = '5' THEN 'Maio'
			WHEN MONTH(dataDoc) = '6' THEN 'Junho'
			WHEN MONTH(dataDoc) = '7' THEN 'Julho'
			WHEN MONTH(dataDoc) = '8' THEN 'Agosto'
			WHEN MONTH(dataDoc) = '9' THEN 'Setembro'
			WHEN MONTH(dataDoc) = '10' THEN 'Outubro'
			WHEN MONTH(dataDoc) = '11' THEN 'Novembro'
			WHEN MONTH(dataDoc) = '12' THEN 'Dezembro'
		  END AS mes FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (23, 24)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		$result = $this->chartPagamento();
		return [$data, $result];
	}

	public function chartPagamento()
	{
		$data = null;
		$sql = "SELECT SUM(total) as total, CASE 
			WHEN MONTH(dataDoc) = '1' THEN 'Janeiro'
			WHEN MONTH(dataDoc) = '2' THEN 'Fevereiro'
			WHEN MONTH(dataDoc) = '3' THEN 'Março'
			WHEN MONTH(dataDoc) = '4' THEN 'Abril'
			WHEN MONTH(dataDoc) = '5' THEN 'Maio'
			WHEN MONTH(dataDoc) = '6' THEN 'Junho'
			WHEN MONTH(dataDoc) = '7' THEN 'Julho'
			WHEN MONTH(dataDoc) = '8' THEN 'Agosto'
			WHEN MONTH(dataDoc) = '9' THEN 'Setembro'
			WHEN MONTH(dataDoc) = '10' THEN 'Outubro'
			WHEN MONTH(dataDoc) = '11' THEN 'Novembro'
			WHEN MONTH(dataDoc) = '12' THEN 'Dezembro'
		  END AS mes FROM viewartigomodopagamentodocumento WHERE idTipoDoc IN (24, 30)";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryOneDoc($idTipoDocExistente, $idSerieExistente, $nDocumentoExistente)
	{
		$data = null;
		$sql = "SELECT * FROM viewartigomodopagamentodocumento WHERE idTipoDoc = ? AND idSerie = ? AND descricaoId = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTipoDocExistente, $idSerieExistente, $nDocumentoExistente]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}
}
